<?php
/**
 * Vertical header template.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$elements = array();
$count = 0;
$rows = array( 'top', 'middle', 'bottom' );

foreach ( $rows as $row ) {
	$elements[ $row ] = eltron_get_theme_mod( 'header_elements_vertical_' . $row, array() );
	$count += count( $elements[ $row ] );
}

if ( 1 > $count ) {
	return;
}

$display = eltron_get_theme_mod( 'header_vertical_bar_display' );
?>
<div id="vertical-header" class="eltron-header-vertical <?php echo esc_attr( implode( ' ', apply_filters( 'eltron/frontend/header_vertical_classes', array() ) ) ); ?> eltron-header" itemtype="https://schema.org/WPHeader" itemscope>
	<?php if ( 'fixed' !== $display ) : ?>
		<div class="eltron-popup-background eltron-popup-close"></div>
	<?php endif; ?>

	<div class="eltron-header-vertical-bar eltron-header-section-vertical <?php echo esc_attr( 'fixed' !== $display ? 'eltron-popup-content' : '' ); ?>">
		<div class="eltron-header-vertical-bar-inner eltron-header-section-vertical-inner">
			<div class="eltron-header-section-vertical-column <?php echo esc_attr( ( 0 < count( $elements['middle'] ) ) ? 'eltron-header-section-vertical-column-with-middle' : '' ); ?>">
				<?php foreach ( $rows as $row ) : ?>
					<?php
					// Skip middle column if it's empty
					if ( 'middle' === $row && 0 === count( $elements[ $row ] ) ) {
						continue;
					}
					?>
					<div class="<?php echo esc_attr( 'eltron-header-vertical-bar-' . $row ); ?> eltron-header-section-vertical-row">
						<?php foreach ( $elements[ $row ] as $element ) eltron_header_element( $element ); ?>
					</div>
				<?php endforeach; ?>
			</div>

			<?php if ( 'full-screen' === $display ) : ?>
				<button class="eltron-popup-close-icon eltron-popup-close eltron-toggle"><?php eltron_icon( 'close' ); ?></button>
			<?php endif; ?>
		</div>
	</div>
</div>