<?php
/**
 * Header vertical toggle template.
 *
 * Passed variables:
 *
 * @type string $slug Header element slug.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

if ( 'fixed' === eltron_get_theme_mod( 'header_vertical_bar_display' ) ) {
	return;
}

?>
<div class="<?php echo esc_attr( 'eltron-header-' . $slug ); ?>">
	<button class="eltron-popup-toggle eltron-toggle" data-target="vertical-header">
		<?php eltron_icon( 'menu', array( 'class' => 'eltron-menu-icon' ) ); ?>
		<span class="screen-reader-text"><?php esc_html_e( 'Vertical Header', 'eltron-features' ); ?></span>
	</button>
</div>