<?php
/**
 * Header contact template.
 *
 * Passed variables:
 *
 * @type string $slug Header element slug.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$items = eltron_get_theme_mod( 'header_contact_items', array() );

if ( empty( $items ) ) {
	return;
}

?>
<ul class="<?php echo esc_attr( 'eltron-header-' . $slug ); ?> eltron-header-menu menu">
	<?php foreach ( $items as $item ) : ?>
		<?php
		$title = eltron_get_theme_mod( 'header_contact_' . $item . '_title' );
		$text = eltron_get_theme_mod( 'header_contact_' . $item . '_text' );
		$url = eltron_get_theme_mod( 'header_contact_' . $item . '_url' );
		?>
		<li class="menu-item">
			<<?php echo ( ! empty( $url ) ) ? 'a href="' . esc_url( $url ) . '"' : 'span'; ?>>
				<?php eltron_icon( $item, array( 'class' => 'eltron-menu-icon' ) ); ?>
				<?php if ( '' !== trim( $title . $text ) ) : ?>
					<span class="eltron-header-contact-item-content">
						<?php if ( 'large' === eltron_get_theme_mod( 'header_contact_style' ) ) : ?>
							<span class="eltron-header-contact-item-title"><?php echo $title; // WPCS: XSS OK. ?></span>
						<?php endif; ?>
						<span class="eltron-header-contact-item-text"><?php echo $text; // WPCS: XSS OK. ?></span>
					</span>
				<?php endif; ?>
			</<?php echo ( ! empty( $url ) ) ? 'a' : 'span'; ?>>
		</li>
	<?php endforeach; ?>
</ul>