<?php
/**
 * Header button template.
 *
 * Passed variables:
 *
 * @type string $slug Header element slug.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$key = str_replace( '-', '_', $slug );
?>
<div class="<?php echo esc_attr( 'eltron-header-' . $slug ); ?> eltron-header-button">
	<a href="<?php echo esc_url( eltron_get_theme_mod( 'header_' . $key . '_url' ) ); ?>" class="button" target="<?php echo esc_attr( '_' . eltron_get_theme_mod( 'header_' . $key . '_target' ) ); ?>">
		<?php echo ( eltron_get_theme_mod( 'header_' . $key . '_text' ) ); // WPCS: XSS OK ?>
	</a>
</div>