<?php
/**
 * Blog Featured Posts template.
 *
 * @package Eltron
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$layout = eltron_get_theme_mod( 'blog_featured_posts_layout' );
$meta_1 = eltron_get_theme_mod( 'blog_featured_posts_meta_1' );
$meta_2 = eltron_get_theme_mod( 'blog_featured_posts_meta_2' );

$classes = array( 'eltron-featured-posts', 'eltron-featured-posts-' . $layout );
$config = array();

// Grid
if ( 0 === strpos( $layout, 'grid-' ) ) {
	$classes[] = 'eltron-featured-posts-grid';
}

// Slider & Carousel
if ( in_array( $layout, array( 'slider', 'carousel' ) ) ) {
	$classes[] = 'eltron-featured-posts-tiny-slider';

	$config['autoplay'] = intval( eltron_get_theme_mod( 'blog_featured_posts_autoplay' ) ) ? true : false;
	$config['autoplayTimeout'] = 1000 * floatval( eltron_get_theme_mod( 'blog_featured_posts_autoplay_delay' ) );
}

// Slider
if ( 'slider' === $layout ) {
	$config['mode'] = 'gallery';

	$config['items'] = 1;
}

// Carousel
if ( 'carousel' === $layout ) {
	$config['mode'] = 'carousel';

	// Mobile
	$config['items'] = intval( eltron_get_theme_mod( 'blog_featured_posts_carousel_columns__mobile', eltron_get_theme_mod( 'blog_featured_posts_carousel_columns', 1 ) ) );

	$config['responsive'] = array(
		// Tablet
		768 => array(
			'items'  => intval( eltron_get_theme_mod( 'blog_featured_posts_carousel_columns__tablet', eltron_get_theme_mod( 'blog_featured_posts_carousel_columns', 2 ) ) ),
		),
		// Desktop
		1024 => array(
			'items'  => intval( eltron_get_theme_mod( 'blog_featured_posts_carousel_columns', 3 ) ),
		),
	);
}

// Carousel & Grid 3
if ( 'slider' !== $layout ) {
	$bg = eltron_get_theme_mod( 'blog_featured_posts_content_bg_mode' );
} else {
	$bg = 'solid';
}
$classes[] = 'eltron-featured-posts-content-bg-mode--' . $bg;

?>
<div id="eltron-featured-posts" class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>" data-config="<?php echo esc_attr( json_encode( $config ) ); ?>">
	<ul class="eltron-featured-posts-list">
		<?php $i = 0; while ( have_posts() ) : the_post(); ?>
			<li class="eltron-featured-post <?php echo esc_attr( 'eltron-featured-post-' . ( $i + 1 ) ); ?>">
				<div class="eltron-featured-post-inner">
					<?php printf(
						/* translators: %1$s: HTML tag (a or div), %2$s: href attribute (if it's a link), %3$s: image URL. */
						'<%1$s %2$s class="eltron-featured-post-background" style="background-image: url(%3$s)"></%1$s>',
						intval( eltron_get_theme_mod( 'blog_featured_posts_image_link' ) ) ? 'a' : 'div',
						intval( eltron_get_theme_mod( 'blog_featured_posts_image_link' ) ) ? 'href="' . esc_url( get_permalink() ) . '"' : '',
						esc_attr( get_the_post_thumbnail_url( null, 'full' ) )
					); ?>

					<div class="eltron-featured-post-text <?php echo esc_attr( 'eltron-text-align-' . eltron_get_theme_mod( 'blog_featured_posts_content_alignment' ) ); ?>">
						<?php if ( '' !== $meta_1 ) : ?>
							<div class="eltron-featured-post-meta-1 eltron-featured-post-meta entry-meta"><?php eltron_entry_meta_element( $meta_1 ); ?></div>
						<?php endif; ?>

						<?php
						$title_class = 'title';
						if ( 'slider' !== $layout ) {
							$title_class = 'small-title';
						}
						?>
						<h2 class="eltron-featured-post-title <?php echo esc_attr( $title_class ); ?>"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>

						<?php if ( '' !== $meta_2 ) : ?>
							<div class="eltron-featured-post-meta-2 eltron-featured-post-meta entry-meta"><?php eltron_entry_meta_element( $meta_2 ); ?></div>
						<?php endif; ?>
					</div>
				</div>
			</li>
		<?php $i++; endwhile; ?>
	</ul>

	<?php if ( in_array( $layout, array( 'slider', 'carousel' ) ) ) : ?>
		<div class="eltron-featured-posts-navigation">
			<button class="eltron-featured-posts-navigation-button eltron-featured-posts-navigation-prev"><?php echo eltron_icon( 'chevron-left' ); ?></button>
			<button class="eltron-featured-posts-navigation-button eltron-featured-posts-navigation-next"><?php echo eltron_icon( 'chevron-right' ); ?></button>
		</div>
	<?php endif; ?>
</div>