<?php
/**
 * Eltron Pro module: WooCommerce Quick View
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

class Eltron_Pro_Module_WooCommerce_Quick_View extends Eltron_Pro_Module_WooCommerce {

	/**
	 * Module name
	 *
	 * @var string
	 */
	const MODULE_SLUG = 'woocommerce-quick-view';

	/**
	 * ====================================================
	 * Singleton & constructor functions
	 * ====================================================
	 */

	/**
	 * Class constructor
	 */
	protected function __construct() {
		parent::__construct();

		// Dynamic CSS
		add_filter( 'eltron/frontend/woocommerce/pro_dynamic_css', array( $this, 'add_dynamic_css' ) );

		// Customizer settings & values
		add_action( 'customize_register', array( $this, 'register_customizer_settings' ) );
		add_filter( 'eltron/customizer/setting_defaults', array( $this, 'add_customizer_setting_defaults' ) );
		add_filter( 'eltron/customizer/setting_postmessages', array( $this, 'add_customizer_setting_postmessages' ) );

		// Template hooks
		add_action( 'init', array( $this, 'modify_template_hooks' ) );

		// AJAX callbacks
		add_action( 'wp_ajax_eltron_woocommerce_render_product_quick_view', array( $this, 'ajax_woocommerce_render_product_quick_view' ) );
		add_action( 'wp_ajax_nopriv_eltron_woocommerce_render_product_quick_view', array( $this, 'ajax_woocommerce_render_product_quick_view' ) );
	}
	
	/**
	 * ====================================================
	 * Hook functions
	 * ====================================================
	 */

	/**
	 * Add dynamic CSS from customizer settings into the inline CSS.
	 *
	 * @param string $css
	 * @return string
	 */
	public function add_dynamic_css( $css ) {
		// Skip adding dynamic CSS on customizer preview frame.
		if ( is_customize_preview() ) {
			return $css;
		}

		$postmessages = include( ELTRON_PRO_DIR . '/inc/modules/' . self::MODULE_SLUG . '/customizer/postmessages.php' );
		$defaults = include( ELTRON_PRO_DIR . '/inc/modules/' . self::MODULE_SLUG . '/customizer/defaults.php' );

		$css .= Eltron_Customizer::instance()->convert_postmessages_to_css_string( $postmessages, $defaults );

		return $css;
	}

	/**
	 * Register customizer sections, settings, and controls.
	 *
	 * @param WP_Customize_Manager $wp_customize
	 */
	public function register_customizer_settings( $wp_customize ) {
		$defaults = Eltron_Customizer::instance()->get_setting_defaults();

		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/_sections.php' );
		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/woocommerce--quick-view.php' );
	}
	
	/**
	 * Add default values for all Customizer settings.
	 *
	 * @param array $defaults
	 * @return array
	 */
	public function add_customizer_setting_defaults( $defaults = array() ) {
		$add = include( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/defaults.php' );

		return array_merge_recursive( $defaults, $add );
	}

	/**
	 * Add postmessage rules for some Customizer settings.
	 *
	 * @param array $postmessages
	 * @return array
	 */
	public function add_customizer_setting_postmessages( $postmessages = array() ) {
		$add = include( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/postmessages.php' );

		return array_merge_recursive( $postmessages, $add );
	}

	/**
	 * Modify filters for WooCommerce template rendering.
	 */
	public function modify_template_hooks() {
		// Add quick view.
		if ( intval( eltron_get_theme_mod( 'woocommerce_quick_view' ) ) ) {
			add_action( 'woocommerce_before_shop_loop_item_title', array( $this, 'render_loop_item_quick_view_button' ), 20 );
			add_action( 'eltron/frontend/after_canvas', array( $this, 'render_loop_item_quick_view_popup' ) );
		}
	}
	
	/**
	 * ====================================================
	 * Render functions
	 * ====================================================
	 */

	/**
	 * Render quick view button on product thumbnail wrapper.
	 */
	public function render_loop_item_quick_view_button() {
		eltron_get_template_part( 'woocommerce-quick-view-button' );
	}

	/**
	 * Render quick view popup.
	 */
	public function render_loop_item_quick_view_popup() {
		eltron_get_template_part( 'woocommerce-quick-view-popup' );
	}
	
	/**
	 * ====================================================
	 * AJAX functions
	 * ====================================================
	 */

	/**
	 * AJAX callback to get status of plugins.
	 */
	public function ajax_woocommerce_render_product_quick_view() {
		if ( ! isset( $_GET['product_id'] ) ) {
			wp_die();
		}

		if ( function_exists( 'wc_get_product' ) ) {
			// Temporarily override the global $post variable.
			global $post;
			$temp = $post;

			// Get the product.
			$post = get_post( $_GET['product_id'] );

			// Abort if it's not a WooCommerce product.
			if ( 'product' !== get_post_type( $post ) ) {
				wp_die();
			}
			
			// Assign to global post.
			setup_postdata( $post );

			// Remove all actions after product summary.
			remove_all_actions( 'woocommerce_after_single_product_summary' );

			// Print single product.
			if ( function_exists( 'wc_get_template_part' ) ) {
				wc_get_template_part( 'content', 'single-product' );
			}

			// Reset global post to its original.
			$post = $temp;
			wp_reset_postdata();
		}

		wp_die();
	}
}

Eltron_Pro_Module_WooCommerce_Quick_View::instance();