<?php
/**
 * Customizer settings: WooCommerce > Checkout Page
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'woocommerce_checkout';

/**
 * ====================================================
 * Distraction Free Mode
 * ====================================================
 */

// ------
$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_woocommerce_checkout_distraction_free', array(
	'section'     => $section,
	'settings'    => array(),
	'priority'    => 30,
) ) );

// Enable distraction free mode
$key = 'woocommerce_checkout_distraction_free';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Enable distraction free mode', 'eltron-features' ),
	'description' => esc_html__( 'Simplify your original header, page header, and footer to only show logo and copyright. This will help users to focus only on the checkout process.', 'eltron-features' ),
	'priority'    => 30,
) ) );