<?php
/**
 * Eltron Pro module: WooCommerce AJAX Add To Cart
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

class Eltron_Pro_Module_WooCommerce_AJAX_Add_To_Cart extends Eltron_Pro_Module_WooCommerce {

	/**
	 * Module name
	 *
	 * @var string
	 */
	const MODULE_SLUG = 'woocommerce-ajax-add-to-cart';

	/**
	 * ====================================================
	 * Singleton & constructor functions
	 * ====================================================
	 */

	/**
	 * Class constructor
	 */
	protected function __construct() {
		parent::__construct();

		// Customizer settings & values
		add_action( 'customize_register', array( $this, 'register_customizer_settings' ) );
		add_filter( 'eltron/customizer/setting_defaults', array( $this, 'add_customizer_setting_defaults' ) );

		// Frontend
		add_action( 'init', array( $this, 'init_frontend' ) );
	}
	
	/**
	 * ====================================================
	 * Hook functions
	 * ====================================================
	 */

	/**
	 * Register customizer sections, settings, and controls.
	 *
	 * @param WP_Customize_Manager $wp_customize
	 */
	public function register_customizer_settings( $wp_customize ) {
		$defaults = Eltron_Customizer::instance()->get_setting_defaults();

		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/_sections.php' );
		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/woocommerce--ajax-add-to-cart.php' );
	}
	
	/**
	 * Add default values for all Customizer settings.
	 *
	 * @param array $defaults
	 * @return array
	 */
	public function add_customizer_setting_defaults( $defaults = array() ) {
		$add = include( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/defaults.php' );

		return array_merge_recursive( $defaults, $add );
	}

	/**
	 * Initialize AJAX add to cart.
	 */
	public function init_frontend() {
		// Add class to add to cart form wrapper.
		if ( intval( eltron_get_theme_mod( 'woocommerce_single_ajax_add_to_cart' ) ) ) {
			add_filter( 'eltron/frontend/woocommerce/add_to_cart_form_classes', array( $this, 'add_single_add_to_cart_form_class' ) );

			if ( intval( eltron_get_theme_mod( 'woocommerce_ajax_added_to_cart_open_header_cart' ) ) ) {
				add_filter( 'body_class', array( $this, 'add_ajax_added_to_cart_effect_to_body_class' ) );
			}
		}
	}

	/**
	 * Add class on single product add to cart form.
	 *
	 * @param array $classes
	 * @return array
	 */
	public function add_single_add_to_cart_form_class( $classes ) {
		$classes['eltron-ajax-add-to-cart-form'] = esc_attr( 'eltron-ajax-add-to-cart-form' );

		return $classes;
	}

	/**
	 * Add class on body tag for ajax added to cart effect.
	 *
	 * @param array $classes
	 * @return array
	 */
	public function add_ajax_added_to_cart_effect_to_body_class( $classes ) {
		$classes['eltron-ajax-added-to-cart-open-header-cart'] = esc_attr( 'eltron-ajax-added-to-cart-open-header-cart' );

		return $classes;
	}
}

Eltron_Pro_Module_WooCommerce_AJAX_Add_To_Cart::instance();