<?php
/**
 * Customizer settings: Header > Vertical Bar
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_header_vertical_bar';

/**
 * ====================================================
 * Layout
 * ====================================================
 */

// Display
$key = 'header_vertical_bar_display';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( $key, array(
	'type'        => 'select',
	'section'     => $section,
	'label'       => esc_html__( 'Display', 'eltron-features' ),
	'choices'     => array(
		'fixed'       => esc_html__( 'Fixed (always visible)', 'eltron-features' ),
		'drawer'      => esc_html__( 'Drawer (triggered via "Vertical Toggle")', 'eltron-features' ),
		'off-canvas'  => esc_html__( 'Off canvas (triggered via "Vertical Toggle")', 'eltron-features' ),
		'full-screen' => esc_html__( 'Full screen (triggered via "Vertical Toggle")', 'eltron-features' ),
	),
	'priority'    => 10,
) );

// Position
$key = 'header_vertical_bar_position';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( $key, array(
	'type'        => 'select',
	'section'     => $section,
	'label'       => esc_html__( 'Position', 'eltron-features' ),
	'choices'     => array(
		'left'   => is_rtl() ? esc_html__( 'Right', 'eltron-features' ) : esc_html__( 'Left', 'eltron-features' ),
		'right'  => is_rtl() ? esc_html__( 'Left', 'eltron-features' ) : esc_html__( 'Right', 'eltron-features' ),
		'center' => esc_html__( 'Center (only for Full Screen)', 'eltron-features' ),
	),
	'priority'    => 10,
) );

// Alignment
$key = 'header_vertical_bar_alignment';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( $key, array(
	'type'        => 'select',
	'section'     => $section,
	'label'       => esc_html__( 'Alignment', 'eltron-features' ),
	'choices'     => array(
		'left'   => is_rtl() ? esc_html__( 'Right', 'eltron-features' ) : esc_html__( 'Left', 'eltron-features' ),
		'center' => esc_html__( 'Center', 'eltron-features' ),
		'right'  => is_rtl() ? esc_html__( 'Left', 'eltron-features' ) : esc_html__( 'Right', 'eltron-features' ),
	),
	'priority'    => 10,
) );

// Width
$key = 'header_vertical_bar_width';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Slider( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Width', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'  => 120,
			'max'  => 600,
			'step' => 1,
		),
	),
	'priority'    => 10,
) ) );

// Padding
$key = 'header_vertical_bar_padding';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimensions' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Dimensions( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Padding', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'step' => 1,
		),
		'em' => array(
			'min'  => 0,
			'step' => 0.05,
		),
		'%' => array(
			'min'  => 0,
			'step' => 0.01,
		),
	),
	'priority'    => 10,
) ) );

// Border
$key = 'header_vertical_bar_border';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimensions' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Dimensions( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Border', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'step' => 1,
		),
	),
	'priority'    => 10,
) ) );

// Items gutter
$key = 'header_vertical_bar_items_gutter';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Slider( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Spacing between elements', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'   => 0,
			'max'   => 40,
			'step'  => 1,
		),
	),
	'priority'    => 10,
) ) );

/**
 * ====================================================
 * Typography
 * ====================================================
 */

// Heading: Typography
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_header_vertical_bar_typography', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Typography', 'eltron-features' ),
	'priority'    => 20,
) ) );

// Text typography
$settings = array(
	'font_family'    => 'header_vertical_bar_font_family',
	'font_weight'    => 'header_vertical_bar_font_weight',
	'font_style'     => 'header_vertical_bar_font_style',
	'text_transform' => 'header_vertical_bar_text_transform',
	'font_size'      => 'header_vertical_bar_font_size',
	'line_height'    => 'header_vertical_bar_line_height',
	'letter_spacing' => 'header_vertical_bar_letter_spacing',
);
foreach ( $settings as $key ) {
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'typography' ),
	) );
}
$wp_customize->add_control( new Eltron_Customize_Control_Typography( $wp_customize, 'header_vertical_bar_typography', array(
	'settings'    => $settings,
	'section'     => $section,
	'label'       => esc_html__( 'Text typography', 'eltron-features' ),
	'priority'    => 20,
) ) );

// Menu link typography
$settings = array(
	'font_family'    => 'header_vertical_bar_menu_font_family',
	'font_weight'    => 'header_vertical_bar_menu_font_weight',
	'font_style'     => 'header_vertical_bar_menu_font_style',
	'text_transform' => 'header_vertical_bar_menu_text_transform',
	'font_size'      => 'header_vertical_bar_menu_font_size',
	'line_height'    => 'header_vertical_bar_menu_line_height',
	'letter_spacing' => 'header_vertical_bar_menu_letter_spacing',
);
foreach ( $settings as $key ) {
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'typography' ),
	) );
}
$wp_customize->add_control( new Eltron_Customize_Control_Typography( $wp_customize, 'header_vertical_bar_menu_typography', array(
	'settings'    => $settings,
	'section'     => $section,
	'label'       => esc_html__( 'Menu link typography', 'eltron-features' ),
	'priority'    => 20,
) ) );

// Submenu link typography
$settings = array(
	'font_family'    => 'header_vertical_bar_submenu_font_family',
	'font_weight'    => 'header_vertical_bar_submenu_font_weight',
	'font_style'     => 'header_vertical_bar_submenu_font_style',
	'text_transform' => 'header_vertical_bar_submenu_text_transform',
	'font_size'      => 'header_vertical_bar_submenu_font_size',
	'line_height'    => 'header_vertical_bar_submenu_line_height',
	'letter_spacing' => 'header_vertical_bar_submenu_letter_spacing',
);
foreach ( $settings as $key ) {
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'typography' ),
	) );
}
$wp_customize->add_control( new Eltron_Customize_Control_Typography( $wp_customize, 'header_vertical_bar_submenu_typography', array(
	'settings'    => $settings,
	'section'     => $section,
	'label'       => esc_html__( 'Submenu link typography', 'eltron-features' ),
	'priority'    => 20,
) ) );

// Icon size
$key = 'header_vertical_bar_icon_size';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Slider( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Icon size', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'max'  => 60,
			'step' => 1,
		),
	),
	'priority'    => 20,
) ) );

/**
 * ====================================================
 * Colors
 * ====================================================
 */

// Heading: Colors
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_header_vertical_bar_colors', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Colors', 'eltron-features' ),
	'priority'    => 30,
) ) );

// Box shadow
$key = 'header_vertical_bar_shadow';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'shadow' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Shadow( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Box shadow', 'eltron-features' ),
	'exclude'     => array( 'h_offset', 'v_offset' ),
	'priority'    => 30,
) ) );

// Colors
$colors = array(
	'header_vertical_bar_bg_color'              => esc_html__( 'Background color', 'eltron-features' ),
	'header_vertical_bar_border_color'          => esc_html__( 'Border color', 'eltron-features' ),
	'header_vertical_bar_text_color'            => esc_html__( 'Text color', 'eltron-features' ),
	'header_vertical_bar_link_text_color'       => esc_html__( 'Link text color', 'eltron-features' ),
	'header_vertical_bar_link_hover_text_color' => esc_html__( 'Link text color :hover', 'eltron-features' ),
);
foreach ( $colors as $key => $label ) {
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
	) );
	$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
		'section'     => $section,
		'label'       => $label,
		'priority'    => 30,
	) ) );
}