<?php
/**
 * Customizer settings: Header > Header Builder
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_header_builder';

/**
 * ====================================================
 * Builder
 * ====================================================
 */

/**
 * Desktop Header (replacing the default one)
 */

// Get default control.
$header_elements = $wp_customize->get_control( 'header_elements' );

// Add new locations.
$settings = array_merge( $header_elements->locations, array(
	'vertical_top'    => 'header_elements_vertical_top',
	'vertical_middle' => 'header_elements_vertical_middle',
	'vertical_bottom' => 'header_elements_vertical_bottom',
) );

// Add new elements.
$choices = array_merge( $header_elements->choices, array(
	'vertical-menu'   => '<span class="dashicons dashicons-admin-links"></span>' . esc_html__( 'Vertical Menu', 'eltron-features' ),
	'vertical-toggle' => '<span class="dashicons dashicons-menu"></span>' . esc_html__( 'Vertical Toggle', 'eltron-features' ),
) );

// Add new labels.
$labels = array_merge( $header_elements->labels, array(
	'vertical_top'    => esc_html__( 'Vertical - Top', 'eltron-features' ),
	'vertical_middle' => esc_html__( 'Vertical - Middle', 'eltron-features' ),
	'vertical_bottom' => esc_html__( 'Vertical - Bottom', 'eltron-features' ),
) );

// Add new limitations.
$limitations = array_merge( $header_elements->limitations, array(
	// Free elements
	'menu-1'          => array( 'vertical_top', 'vertical_middle', 'vertical_bottom' ),
	'search-dropdown' => array( 'vertical_top', 'vertical_middle', 'vertical_bottom' ),

	// Pro elements
	'menu-2'          => array( 'vertical_top', 'vertical_middle', 'vertical_bottom' ),
	'menu-3'          => array( 'vertical_top', 'vertical_middle', 'vertical_bottom' ),
	'vertical-menu'   => array( 'top_left', 'top_center', 'top_right', 'main_left', 'main_center', 'main_right', 'bottom_left', 'bottom_center', 'bottom_right' ),
	'vertical-toggle' => array( 'vertical_top', 'vertical_middle', 'vertical_bottom' ),
) );
if ( class_exists( 'WooCommerce' ) ) {
	$limitations = array_merge( $limitations, array(
		'shopping-cart-link'     => array( 'vertical_top', 'vertical_middle', 'vertical_bottom' ),
		'shopping-cart-dropdown' => array( 'vertical_top', 'vertical_middle', 'vertical_bottom' ),
	) );
}

// Re-create the control.
foreach ( $settings as $key ) {
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'builder' ),
	) );
}
$wp_customize->add_control( new Eltron_Customize_Control_Builder( $wp_customize, 'header_elements', array(
	'settings'    => $settings,
	'section'     => $section,
	'label'       => $header_elements->label,
	'description' => $header_elements->description,
	'choices'     => $choices,
	'labels'      => $labels,
	'limitations' => $limitations,
	'priority'    => $header_elements->priority,
) ) );