<?php
/**
 * Eltron Pro module: Vertical Header
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

class Eltron_Pro_Module_Header_Vertical extends Eltron_Pro_Module {

	/**
	 * Module name
	 *
	 * @var string
	 */
	const MODULE_SLUG = 'header-vertical';

	/**
	 * ====================================================
	 * Singleton & constructor functions
	 * ====================================================
	 */

	/**
	 * Class constructor
	 */
	protected function __construct() {
		parent::__construct();

		// Dynamic CSS
		add_filter( 'eltron/frontend/pro_dynamic_css', array( $this, 'add_dynamic_css' ) );

		// Register new menus
		add_action( 'init', array( $this, 'register_new_menus' ) );

		// Customizer settings & values
		add_action( 'customize_register', array( $this, 'register_customizer_settings' ) );
		add_filter( 'eltron/customizer/setting_defaults', array( $this, 'add_customizer_setting_defaults' ) );
		add_filter( 'eltron/customizer/setting_postmessages', array( $this, 'add_customizer_setting_postmessages' ) );
		add_filter( 'eltron/customizer/control_contexts', array( $this, 'add_customizer_control_contexts' ) );

		// Template actions
		add_action( 'eltron/frontend/before_canvas', array( $this, 'render_vertical_header' ) );

		// Template filters
		add_filter( 'eltron/frontend/header_vertical_classes', array( $this, 'header_vertical_classes' ), 10, 2 );
	}
	
	/**
	 * ====================================================
	 * Hook functions
	 * ====================================================
	 */

	/**
	 * Add dynamic CSS from customizer settings into the inline CSS.
	 *
	 * @param string $css
	 * @return string
	 */
	public function add_dynamic_css( $css ) {
		// Skip adding dynamic CSS on customizer preview frame.
		if ( is_customize_preview() ) {
			return $css;
		}

		$postmessages = include( ELTRON_PRO_DIR . '/inc/modules/' . self::MODULE_SLUG . '/customizer/postmessages.php' );
		$defaults = include( ELTRON_PRO_DIR . '/inc/modules/' . self::MODULE_SLUG . '/customizer/defaults.php' );

		$css .= Eltron_Customizer::instance()->convert_postmessages_to_css_string( $postmessages, $defaults );

		return $css;
	}

	/**
	 * Registers additional menu locations.
	 */
	public function register_new_menus() {
		register_nav_menus( array(
			/* translators: %d: number of Header Menu. */
			'header-menu-2' => sprintf( esc_html__( 'Header Menu %d', 'eltron-features' ), 2 ),
			/* translators: %d: number of Header Menu. */
			'header-menu-3' => sprintf( esc_html__( 'Header Menu %d', 'eltron-features' ), 3 ),
			'header-vertical-menu' => esc_html__( 'Vertical Header Menu', 'eltron-features' ),
		) );
	}

	/**
	 * Register customizer sections, settings, and controls.
	 *
	 * @param WP_Customize_Manager $wp_customize
	 */
	public function register_customizer_settings( $wp_customize ) {
		$defaults = Eltron_Customizer::instance()->get_setting_defaults();

		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/_sections.php' );
		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/header--builder.php' );
		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/header--vertical-bar.php' );
	}
	
	/**
	 * Add default values for all Customizer settings.
	 *
	 * @param array $defaults
	 * @return array
	 */
	public function add_customizer_setting_defaults( $defaults = array() ) {
		$add = include( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/defaults.php' );

		return array_merge_recursive( $defaults, $add );
	}

	/**
	 * Add postmessage rules for some Customizer settings.
	 *
	 * @param array $postmessages
	 * @return array
	 */
	public function add_customizer_setting_postmessages( $postmessages = array() ) {
		$add = include( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/postmessages.php' );

		return array_merge_recursive( $postmessages, $add );
	}

	/**
	 * Add dependency contexts for some Customizer settings.
	 *
	 * @param array $contexts
	 * @return array
	 */
	public function add_customizer_control_contexts( $contexts = array() ) {
		$add = include( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/contexts.php' );

		return array_merge_recursive( $contexts, $add );
	}

	/**
	 * Add custom classes to the array of header main bar section classes.
	 *
	 * @param array $classes
	 * @return array
	 */
	function header_vertical_classes( $classes ) {
		$display = eltron_get_theme_mod( 'header_vertical_bar_display' );

		$classes['display'] = esc_attr( 'eltron-header-vertical-display-' . $display );
		$classes['position'] = esc_attr( 'eltron-header-vertical-position-' . eltron_get_theme_mod( 'header_vertical_bar_position' ) );

		if ( 'fixed' !== $display ) {
			$classes['popup'] = esc_attr( 'eltron-popup' );
		}

		$classes['alignment'] = esc_attr( 'eltron-text-align-' . eltron_get_theme_mod( 'header_vertical_bar_alignment' ) );

		return $classes;
	}

	/**
	 * ====================================================
	 * Render functions
	 * ====================================================
	 */

	/**
	 * Render vertical header.
	 */
	public function render_vertical_header() {
		if ( intval( eltron_get_current_page_setting( 'disable_header' ) ) ) {
			return;
		}

		eltron_get_template_part( 'header-vertical' );
	}
}

Eltron_Pro_Module_Header_Vertical::instance();