<?php
/**
 * Customizer settings: Header > Alternate Header Colors
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_header_alt_colors';

/**
 * ====================================================
 * Desktop
 * ====================================================
 */

$priority = 15;
$bars = array(
	'top_bar'    => esc_html__( 'Top Bar', 'eltron-features' ),
	'main_bar'   => esc_html__( 'Main Bar', 'eltron-features' ),
	'bottom_bar' => esc_html__( 'Bottom Bar', 'eltron-features' )
);
foreach ( $bars as $bar => $label ) {
	$priority += 10;

	// Colors
	$colors = array(
		'header_' . $bar . '_alt_transparent_bg_color'     => esc_html__( 'Transparent header: Background color', 'eltron-features' ),
		'header_' . $bar . '_alt_transparent_border_color' => esc_html__( 'Transparent header: Border color', 'eltron-features' ),
	);
	foreach ( $colors as $key => $label ) {
		$wp_customize->add_setting( $key, array(
			'default'     => eltron_array_value( $defaults, $key ),
			'transport'   => 'postMessage',
			'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
		) );
		$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
			'section'     => $section,
			'label'       => $label,
			'priority'    => $priority,
		) ) );
	}
}

/**
 * ====================================================
 * Mobile
 * ====================================================
 */

// Colors
$colors = array(
	'header_mobile_main_bar_alt_bg_color'                 => esc_html__( 'Background color', 'eltron-features' ),
	'header_mobile_main_bar_alt_border_color'             => esc_html__( 'Border color', 'eltron-features' ),
	'header_mobile_main_bar_alt_link_text_color'          => esc_html__( 'Link text color', 'eltron-features' ),
	'header_mobile_main_bar_alt_link_hover_text_color'    => esc_html__( 'Link text color :hover', 'eltron-features' ),
	'header_mobile_main_bar_alt_transparent_bg_color'     => esc_html__( 'Transparent header: Background color', 'eltron-features' ),
	'header_mobile_main_bar_alt_transparent_border_color' => esc_html__( 'Transparent header: Border color', 'eltron-features' ),
);
foreach ( $colors as $key => $label ) {
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
	) );
	$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
		'section'     => $section,
		'label'       => $label,
		'priority'    => 65,
	) ) );
}