<?php
/**
 * Customizer & Front-End modification rules.
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$add = array();

/**
 * ====================================================
 * Header > Sticky Header
 * ====================================================
 */

$add['header_sticky_bar_bg_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-main .eltron-header-sticky.eltron-sticky-in-view .eltron-section-inner',
		'property' => 'background-color',
	),
);
$add['header_sticky_bar_border_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-main .eltron-header-sticky.eltron-sticky-in-view *',
		'property' => 'border-color',
	),
);
$add['header_sticky_bar_text_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-main .eltron-header-sticky.eltron-sticky-in-view',
		'property' => 'color',
	),
);
$add['header_sticky_bar_link_text_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-main .eltron-header-sticky.eltron-sticky-in-view a:not(.button), .eltron-header-main .eltron-header-sticky.eltron-sticky-in-view .eltron-toggle',
		'property' => 'color',
	),
);
$add['header_sticky_bar_link_hover_text_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-main .eltron-header-sticky.eltron-sticky-in-view a:not(.button):hover, .eltron-header-main .eltron-header-sticky.eltron-sticky-in-view a:not(.button):focus, .eltron-header-main .eltron-header-sticky.eltron-sticky-in-view .eltron-toggle:hover, .eltron-header-main .eltron-header-sticky.eltron-sticky-in-view .eltron-toggle:focus',
		'property' => 'color',
	),
);
$add['header_sticky_bar_menu_hover_highlight_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-main .eltron-header-sticky.eltron-sticky-in-view:not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .menu-item > .eltron-menu-item-link:hover:after, .eltron-header-main .eltron-header-sticky.eltron-sticky-in-view:not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .menu-item > .eltron-menu-item-link:focus:after',
		'property' => 'background-color',
	),
);
$add['header_sticky_bar_menu_hover_highlight_text_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-main .eltron-header-sticky.eltron-sticky-in-view:not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .menu-item > .eltron-menu-item-link:hover, .eltron-header-main .eltron-header-sticky.eltron-sticky-in-view:not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .menu-item > .eltron-menu-item-link:focus',
		'property' => 'color',
	),
);
$add['header_sticky_bar_menu_active_highlight_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-main .eltron-header-sticky.eltron-sticky-in-view:not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .current-menu-item > .eltron-menu-item-link:after, .eltron-header-main .eltron-header-sticky.eltron-sticky-in-view:not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .current-menu-ancestor > .eltron-menu-item-link:after',
		'property' => 'background-color',
	),
);
$add['header_sticky_bar_menu_active_highlight_text_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-main .eltron-header-sticky.eltron-sticky-in-view:not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .current-menu-item > .eltron-menu-item-link, .eltron-header-main .eltron-header-sticky.eltron-sticky-in-view:not(.eltron-header-menu-highlight-none) .eltron-header-menu > .menu > .current-menu-ancestor > .eltron-menu-item-link',
		'property' => 'color',
	),
);
$add['header_sticky_bar_shadow'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-main .eltron-header-sticky.eltron-sticky-in-view .eltron-section-inner',
		'property' => 'box-shadow',
	),
);

$add['header_mobile_sticky_bar_bg_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-mobile .eltron-header-sticky.eltron-sticky-in-view .eltron-section-inner',
		'property' => 'background-color',
	),
);
$add['header_mobile_sticky_bar_border_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-mobile .eltron-header-sticky.eltron-sticky-in-view *',
		'property' => 'border-color',
	),
);
$add['header_mobile_sticky_bar_link_text_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-mobile .eltron-header-sticky.eltron-sticky-in-view a:not(.button), .eltron-header-mobile .eltron-header-sticky.eltron-sticky-in-view .eltron-toggle',
		'property' => 'color',
	),
);
$add['header_mobile_sticky_bar_link_hover_text_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-mobile .eltron-header-sticky.eltron-sticky-in-view a:not(.button):hover, .eltron-header-mobile .eltron-header-sticky.eltron-sticky-in-view a:not(.button):focus, .eltron-header-mobile .eltron-header-sticky.eltron-sticky-in-view .eltron-toggle:hover, .eltron-header-mobile .eltron-header-sticky.eltron-sticky-in-view .eltron-toggle:focus',
		'property' => 'color',
	),
);
$add['header_mobile_sticky_bar_shadow'] = array(
	array(
		'type'     => 'css',
		'element'  => '.eltron-header-mobile .eltron-header-sticky.eltron-sticky-in-view .eltron-section-inner',
		'property' => 'box-shadow',
	),
);

return $add;