<?php
/**
 * Customizer settings: Header > Sticky Header
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_header_sticky';

/**
 * ====================================================
 * Desktop
 * ====================================================
 */

// Heading: Desktop Header
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_header_sticky', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Desktop Header', 'eltron-features' ),
	'priority'    => 10,
) ) );

// Sticky desktop header
$key = 'header_sticky';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Sticky desktop header', 'eltron-features' ),
	'description' => sprintf(
		/* translators: %s: link to "Page Settings" section. */
		esc_html__( 'This is global default setting, optionally you can enable / disable Sticky Header for each page type via %s.', 'eltron-features' ),
		'<a href="' . esc_url( add_query_arg( 'autofocus[panel]', 'eltron_panel_page_settings' ) ) . '" class="eltron-customize-goto-control">' . esc_html__( 'Page Settings', 'eltron-features' ) . '</a>'
	),
	'priority'    => 10,
) ) );

// ------
$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_header_sticky', array(
	'section'     => $section,
	'settings'    => array(),
	'priority'    => 10,
) ) );

// Sticky bar
$key = 'header_sticky_bar';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( $key, array(
	'type'        => 'select',
	'section'     => $section,
	'label'       => esc_html__( 'Sticky bar', 'eltron-features' ),
	'choices'     => array(
		'top'      => esc_html__( 'Top bar', 'eltron-features' ),
		'main'     => esc_html__( 'Main bar', 'eltron-features' ),
		'bottom'   => esc_html__( 'Bottom bar', 'eltron-features' ),
	),
	'priority'    => 10,
) );

// Sticky display
$key = 'header_sticky_display';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( $key, array(
	'type'        => 'select',
	'section'     => $section,
	'label'       => esc_html__( 'Display', 'eltron-features' ),
	'choices'     => array(
		'fixed'        => esc_html__( 'Always stick', 'eltron-features' ),
		'on-scroll-up' => esc_html__( 'Hide on scroll down, show on scroll up', 'eltron-features' ),
	),
	'priority'    => 10,
) );

// Sticky height
$key = 'header_sticky_height';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Slider( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Height', 'eltron-features' ),
	'description' => esc_html__( 'Should be less than or equal to normal height of the selected bar.', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'   => 20,
			'max'   => 120,
			'step'  => 1,
		),
	),
	'priority'    => 10,
) ) );

// ------
$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_header_sticky_logo', array(
	'section'     => $section,
	'settings'    => array(),
	'priority'    => 10,
) ) );

// Sticky Logo
$key = 'custom_logo_sticky';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => 'absint',
) );
$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Sticky logo image', 'eltron-features' ),
	'mime_type'   => 'image',
	'priority'    => 10,
) ) );

// Max width
$key = 'header_sticky_logo_width';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Dimension( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Max width', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'step' => 1,
		),
	),
	'priority'    => 10,
) ) );

// ------
$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_header_sticky_colors', array(
	'section'     => $section,
	'settings'    => array(),
	'priority'    => 10,
) ) );

// Colors
$colors = array(
	'header_sticky_bar_bg_color'                         => esc_html__( 'Background color', 'eltron-features' ),
	'header_sticky_bar_border_color'                     => esc_html__( 'Border color', 'eltron-features' ),
	'header_sticky_bar_text_color'                       => esc_html__( 'Text color', 'eltron-features' ),
	'header_sticky_bar_link_text_color'                  => esc_html__( 'Link text color', 'eltron-features' ),
	'header_sticky_bar_link_hover_text_color'            => esc_html__( 'Link text color :hover', 'eltron-features' ),
	'header_sticky_bar_menu_hover_highlight_color'       => esc_html__( 'Highlight color :hover', 'eltron-features' ),
	'header_sticky_bar_menu_hover_highlight_text_color'  => esc_html__( 'Highlight text color :hover', 'eltron-features' ),
	'header_sticky_bar_menu_active_highlight_color'      => esc_html__( 'Highlight color :active', 'eltron-features' ),
	'header_sticky_bar_menu_active_highlight_text_color' => esc_html__( 'Highlight text color :active', 'eltron-features' ),
);
foreach ( $colors as $key => $label ) {
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
	) );
	$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
		'section'     => $section,
		'label'       => $label,
		'priority'    => 10,
	) ) );
}

// Sticky bar shadow
$key = 'header_sticky_bar_shadow';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'shadow' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Shadow( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Sticky bar shadow', 'eltron-features' ),
	'priority'    => 20,
) ) );

/**
 * ====================================================
 * Mobile
 * ====================================================
 */

// Heading: Mobile Header
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_header_mobile_sticky', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Mobile Header', 'eltron-features' ),
	'priority'    => 20,
) ) );

// Sticky mobile header
$key = 'header_mobile_sticky';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'toggle' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Toggle( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Sticky mobile header', 'eltron-features' ),
	'description' => sprintf(
		/* translators: %s: link to "Page Settings" section. */
		esc_html__( 'This is global default setting, optionally you can enable / disable Sticky Mobile Header for each page type via %s.', 'eltron-features' ),
		'<a href="' . esc_url( add_query_arg( 'autofocus[panel]', 'eltron_panel_page_settings' ) ) . '" class="eltron-customize-goto-control">' . esc_html__( 'Page Settings', 'eltron-features' ) . '</a>'
	),
	'priority'    => 20,
) ) );

// ------
$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_header_mobile_sticky', array(
	'section'     => $section,
	'settings'    => array(),
	'priority'    => 20,
) ) );

// Sticky mobile display
$key = 'header_mobile_sticky_display';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( $key, array(
	'type'        => 'select',
	'section'     => $section,
	'label'       => esc_html__( 'Display', 'eltron-features' ),
	'choices'     => array(
		'fixed'        => esc_html__( 'Always stick', 'eltron-features' ),
		'on-scroll-up' => esc_html__( 'Hide on scroll down, show on scroll up', 'eltron-features' ),
	),
	'priority'    => 20,
) );

// Sticky height
$key = 'header_mobile_sticky_height';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Slider( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Height', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'   => 20,
			'max'   => 120,
			'step'  => 1,
		),
	),
	'priority'    => 20,
) ) );

// ------
$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_header_mobile_sticky_logo', array(
	'section'     => $section,
	'settings'    => array(),
	'priority'    => 20,
) ) );

// Sticky Logo
$key = 'custom_logo_mobile_sticky';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => 'absint',
) );
$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Sticky logo image', 'eltron-features' ),
	'mime_type'   => 'image',
	'priority'    => 20,
) ) );

// Max width
$key = 'header_mobile_sticky_logo_width';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Dimension( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Max width', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'step' => 1,
		),
	),
	'priority'    => 20,
) ) );

// ------
$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_header_mobile_sticky_colors', array(
	'section'     => $section,
	'settings'    => array(),
	'priority'    => 20,
) ) );

// Colors
$colors = array(
	'header_mobile_sticky_bar_bg_color'              => esc_html__( 'Background color', 'eltron-features' ),
	'header_mobile_sticky_bar_border_color'          => esc_html__( 'Border color', 'eltron-features' ),
	'header_mobile_sticky_bar_link_text_color'       => esc_html__( 'Link text color', 'eltron-features' ),
	'header_mobile_sticky_bar_link_hover_text_color' => esc_html__( 'Link text color :hover', 'eltron-features' ),
);
foreach ( $colors as $key => $label ) {
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
	) );
	$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
		'section'     => $section,
		'label'       => $label,
		'priority'    => 20,
	) ) );
}

// Sticky bar shadow
$key = 'header_mobile_sticky_bar_shadow';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'shadow' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Shadow( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Sticky bar shadow', 'eltron-features' ),
	'priority'    => 20,
) ) );