<?php
/**
 * Customizer settings:
 * - Header > Top Bar
 * - Header > Main Bar
 * - Header > Bottom Bar
 *
 * @package Eltron
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

foreach ( array( 'top_bar', 'main_bar', 'bottom_bar' ) as $bar ) {
	
	$section = 'eltron_section_header_' . $bar;

	/**
	 * ====================================================
	 * Typography
	 * ====================================================
	 */

	// Menu link typography
	$settings = array(
		'font_family'    => 'header_' . $bar . '_mega_menu_heading_font_family',
		'font_weight'    => 'header_' . $bar . '_mega_menu_heading_font_weight',
		'font_style'     => 'header_' . $bar . '_mega_menu_heading_font_style',
		'text_transform' => 'header_' . $bar . '_mega_menu_heading_text_transform',
		'font_size'      => 'header_' . $bar . '_mega_menu_heading_font_size',
		'line_height'    => 'header_' . $bar . '_mega_menu_heading_line_height',
		'letter_spacing' => 'header_' . $bar . '_mega_menu_heading_letter_spacing',
	);
	foreach ( $settings as $key ) {
		$wp_customize->add_setting( $key, array(
			'default'     => eltron_array_value( $defaults, $key ),
			'transport'   => 'postMessage',
			'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'typography' ),
		) );
	}
	$wp_customize->add_control( new Eltron_Customize_Control_Typography( $wp_customize, 'header_' . $bar . '_mega_menu_heading_typography', array(
		'settings'    => $settings,
		'section'     => $section,
		'label'       => esc_html__( 'Mega menu heading typography', 'eltron-features' ),
		'priority'    => 25,
	) ) );

	/**
	 * ====================================================
	 * Colors
	 * ====================================================
	 */

	// ------
	$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_header_' . $bar . '_mega_menu_colors', array(
		'section'     => $section,
		'settings'    => array(),
		'priority'    => 35,
	) ) );

	// Colors
	$colors = array(
		'header_' . $bar . '_mega_menu_heading_text_color'       => esc_html__( 'Mega menu heading text color', 'eltron-features' ),
		'header_' . $bar . '_mega_menu_heading_hover_text_color' => esc_html__( 'Mega menu heading text color :hover', 'eltron-features' ),
	);
	foreach ( $colors as $key => $label ) {
		$wp_customize->add_setting( $key, array(
			'default'     => eltron_array_value( $defaults, $key ),
			'transport'   => 'postMessage',
			'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
		) );
		$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
			'section'     => $section,
			'label'       => $label,
			'priority'    => 35,
		) ) );
	}
}