<?php
/**
 * Customizer settings: Header > Search
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_header_search';

/**
 * ====================================================
 * Search
 * ====================================================
 */

$choices = array(
	'default' => esc_html__( 'Default search', 'eltron-features' ),
);

if ( class_exists( 'WooCommerce' ) ) {
	$choices['products'] = esc_html__( 'Products search (WooCommerce)', 'eltron-features' );
}

if ( 1 < count( $choices ) ) {
	// Search form mode
	$key = 'header_search_mode';
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
	) );
	$wp_customize->add_control( $key, array(
		'type'        => 'select',
		'section'     => $section,
		'label'       => esc_html__( 'Search form mode', 'eltron-features' ),
		'choices'     => $choices,
		'priority'    => 1,
	) );
}