<?php
/**
 * Customizer settings: Header > HTML
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_header_html';

for ( $i = 2; $i <= 3; $i++ ) {
	/**
	 * ====================================================
	 * HTML %d
	 * ====================================================
	 */

	// Heading: HTML
	$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_header_html_' . $i, array(
		'section'     => $section,
		'settings'    => array(),
		/* translators: %d: number of HTML element. */
		'label'       => sprintf( esc_html__( 'HTML %d', 'eltron-features' ), $i ),
		'priority'    => 10,
	) ) );

	// Content
	$key = 'header_html_' . $i . '_content';
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'html' ),
	) );
	$wp_customize->add_control( $key, array(
		'type'        => 'textarea',
		'section'     => $section,
		'description' => esc_html__( 'Plain text, HTML tags, and shortcode are allowed.', 'eltron-features' ),
		'priority'    => 10,
	) );

	// Selective Refresh
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( $key, array(
			'selector'            => '.eltron-header-html-' . $i,
			'container_inclusive' => true,
			'render_callback'     => array( Eltron_Pro_Module_Header_Elements_Plus::instance(), 'render_header_element__html_' . $i ),
			'fallback_refresh'    => false,
		) );
	}
}