<?php
/**
 * Customizer settings: Header > Button(s)
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_header_button';

for ( $i = 1; $i <= 2; $i++ ) {
	$priority = $i * 10;
	
	/**
	 * ====================================================
	 * Button %d
	 * ====================================================
	 */

	// Heading: Button
	$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_header_button_' . $i, array(
		'section'     => $section,
		'settings'    => array(),
		/* translators: %d: number of Button element. */
		'label'       => sprintf( esc_html__( 'Button %d', 'eltron-features' ), $i ),
		'priority'    => $priority,
	) ) );

	// Button URL
	$key = 'header_button_' . $i . '_url';
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => 'esc_url_raw',
	) );
	$wp_customize->add_control( $key, array(
		'section'     => $section,
		'label'       => esc_html__( 'Button link URL', 'eltron-features' ),
		'priority'    => $priority,
	) );

	// Button text
	$key = 'header_button_' . $i . '_text';
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'text' ),
	) );
	$wp_customize->add_control( $key, array(
		'section'     => $section,
		'label'       => esc_html__( 'Button text', 'eltron-features' ),
		'priority'    => $priority,
	) );

	// Button target
	$key = 'header_button_' . $i . '_target';
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
	) );
	$wp_customize->add_control( $key, array(
		'type'        => 'select',
		'section'     => $section,
		'label'       => esc_html__( 'Open button link in', 'eltron-features' ),
		'choices'     => array(
			'self'  => esc_html__( 'Same tab', 'eltron-features' ),
			'blank' => esc_html__( 'New tab', 'eltron-features' ),
		),
		'priority'    => $priority,
	) );
	
	// Selective Refresh
	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'header_button_' . $i, array(
			'settings'            => array(
				'header_button_' . $i . '_url',
				'header_button_' . $i . '_text',
				'header_button_' . $i . '_target',
			),
			'selector'            => '.eltron-header-button-' . $i,
			'container_inclusive' => true,
			'render_callback'     => array( Eltron_Pro_Module_Header_Elements_Plus::instance(), 'render_header_element__button_' . $i ),
			'fallback_refresh'    => false,
		) );
	}
}