<?php
/**
 * Customizer settings: Header > Header Builder
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_header_builder';

/**
 * ====================================================
 * Builder
 * ====================================================
 */

/**
 * Desktop Header (replacing the default one)
 */

// Get default control.
$header_elements = $wp_customize->get_control( 'header_elements' );

// Add new locations.
$settings = $header_elements->locations;

// Add new elements.
$choices = array_merge( $header_elements->choices, array(
	/* translators: %s: instance number. */
	'menu-2'   => '<span class="dashicons dashicons-admin-links"></span>' . sprintf( esc_html__( 'Menu %s', 'eltron-features' ), 2 ),
	/* translators: %s: instance number. */
	'menu-3'   => '<span class="dashicons dashicons-admin-links"></span>' . sprintf( esc_html__( 'Menu %s', 'eltron-features' ), 3 ),
	/* translators: %s: instance number. */
	'html-2'   => '<span class="dashicons dashicons-editor-code"></span>' . sprintf( esc_html__( 'HTML %s', 'eltron-features' ), 2 ),
	/* translators: %s: instance number. */
	'html-3'   => '<span class="dashicons dashicons-editor-code"></span>' . sprintf( esc_html__( 'HTML %s', 'eltron-features' ), 3 ),
	/* translators: %s: instance number. */
	'button-1' => '<span class="dashicons dashicons-share-alt2"></span>' . sprintf( esc_html__( 'Button %s', 'eltron-features' ), 1 ),
	/* translators: %s: instance number. */
	'button-2' => '<span class="dashicons dashicons-share-alt2"></span>' . sprintf( esc_html__( 'Button %s', 'eltron-features' ), 2 ),
	'contact'  => '<span class="dashicons dashicons-phone"></span>' . esc_html__( 'Contact', 'eltron-features' ),
) );

// Add new labels.
$labels = $header_elements->labels;

// Add new limitations.
$limitations = array_merge( $header_elements->limitations, array() );

// Re-create the control.
foreach ( $settings as $key ) {
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'builder' ),
	) );
}
$wp_customize->add_control( new Eltron_Customize_Control_Builder( $wp_customize, 'header_elements', array(
	'settings'    => $settings,
	'section'     => $section,
	'label'       => $header_elements->label,
	'description' => $header_elements->description,
	'choices'     => $choices,
	'labels'      => $labels,
	'limitations' => $limitations,
	'priority'    => $header_elements->priority,
) ) );

/**
 * Mobile Header (replacing the default one)
 */

// Get default control.
$header_mobile_elements = $wp_customize->get_control( 'header_mobile_elements' );

// Add new locations.
$settings = $header_mobile_elements->locations;

// Add new elements.
$choices = array_merge( $header_mobile_elements->choices, array(
	'html-2'   => '<span class="dashicons dashicons-editor-code"></span>' . esc_html__( 'HTML', 'eltron-features' ) . ' 2',
	'html-3'   => '<span class="dashicons dashicons-editor-code"></span>' . esc_html__( 'HTML', 'eltron-features' ) . ' 3',
	'button-1' => '<span class="dashicons dashicons-share-alt2"></span>' . esc_html__( 'Button', 'eltron-features' ) . ' 1',
	'button-2' => '<span class="dashicons dashicons-share-alt2"></span>' . esc_html__( 'Button', 'eltron-features' ) . ' 2',
	'contact'  => '<span class="dashicons dashicons-phone"></span>' . esc_html__( 'Contact', 'eltron-features' ),
) );

// Add new labels.
$labels = $header_mobile_elements->labels;

// Add new limitations.
$limitations = array_merge( $header_mobile_elements->limitations, array(
	'html-2'   => array( 'mobile_main_left', 'mobile_main_center', 'mobile_main_right' ),
	'html-3'   => array( 'mobile_main_left', 'mobile_main_center', 'mobile_main_right' ),
	'button-1' => array( 'mobile_main_left', 'mobile_main_center', 'mobile_main_right' ),
	'button-2' => array( 'mobile_main_left', 'mobile_main_center', 'mobile_main_right' ),
	'contact'  => array( 'mobile_main_left', 'mobile_main_center', 'mobile_main_right' ),
) );

// Re-create the control.
foreach ( $settings as $key ) {
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'builder' ),
	) );
}
$wp_customize->add_control( new Eltron_Customize_Control_Builder( $wp_customize, 'header_mobile_elements', array(
	'settings'    => $settings,
	'section'     => $section,
	'label'       => $header_elements->label,
	'description' => $header_elements->description,
	'choices'     => $choices,
	'labels'      => $labels,
	'limitations' => $limitations,
	'priority'    => $header_elements->priority,
) ) );