<?php
/**
 * Eltron Pro module: Header Elements Plus
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

class Eltron_Pro_Module_Header_Elements_Plus extends Eltron_Pro_Module {

	/**
	 * Module name
	 *
	 * @var string
	 */
	const MODULE_SLUG = 'header-elements-plus';

	/**
	 * ====================================================
	 * Singleton & constructor functions
	 * ====================================================
	 */

	/**
	 * Class constructor
	 */
	protected function __construct() {
		parent::__construct();

		// Register new menus
		add_action( 'init', array( $this, 'register_new_menus' ) );

		// Customizer settings & values
		add_action( 'customize_register', array( $this, 'register_customizer_settings' ) );
		add_filter( 'eltron/customizer/setting_defaults', array( $this, 'add_customizer_setting_defaults' ) );

		// Additional icons
		add_action( 'eltron/dataset/all_icons', array( $this, 'add_icons' ) );
		add_filter( 'eltron/frontend/svg_icon_path', array( $this, 'svg_icon_path' ), 10, 2 );

		// Template filters
		add_filter( 'eltron/frontend/header_element', array( $this, 'modify_header_search' ), 1, 2 );
	}
	
	/**
	 * ====================================================
	 * Hook functions
	 * ====================================================
	 */

	/**
	 * Registers additional menu locations.
	 */
	public function register_new_menus() {
		register_nav_menus( array(
			/* translators: %d: number of Header Menu. */
			'header-menu-2' => sprintf( esc_html__( 'Header Menu %d', 'eltron-features' ), 2 ),
			/* translators: %d: number of Header Menu. */
			'header-menu-3' => sprintf( esc_html__( 'Header Menu %d', 'eltron-features' ), 3 ),
			'header-vertical-menu' => esc_html__( 'Vertical Menu', 'eltron-features' ),
		) );
	}

	/**
	 * Register customizer sections, settings, and controls.
	 *
	 * @param WP_Customize_Manager $wp_customize
	 */
	public function register_customizer_settings( $wp_customize ) {
		$defaults = Eltron_Customizer::instance()->get_setting_defaults();

		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/_sections.php' );
		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/header--builder.php' );
		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/header--html.php' );
		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/header--button.php' );
		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/header--search.php' );
		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/header--contact.php' );
	}
	
	/**
	 * Add default values for all Customizer settings.
	 *
	 * @param array $defaults
	 * @return array
	 */
	public function add_customizer_setting_defaults( $defaults = array() ) {
		$add = include( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/defaults.php' );

		return array_merge_recursive( $defaults, $add );
	}

	/**
	 * Add icons list.
	 *
	 * @param array $choices
	 * @return array
	 */
	public function add_icons( $choices ) {
		$choices['theme_icons'] = array_merge( $choices['theme_icons'], array(
			'email'   => esc_html_x( 'Email', 'icon label', 'eltron-features' ),
			'address' => esc_html_x( 'Address', 'icon label', 'eltron-features' ),
			'phone'   => esc_html_x( 'Phone', 'icon label', 'eltron-features' ),
			'time'    => esc_html_x( 'Time', 'icon label', 'eltron-features' ),
		) );

		return $choices;
	}

	/**
	 * Modify SVG icon path for some new icons.
	 *
	 * @param string $path
	 * @param string $key
	 * @return string
	 */
	public function svg_icon_path( $path, $key ) {
		if ( in_array( $key, array( 'email', 'address', 'phone', 'time' ) ) ) {
			$path = ELTRON_PRO_DIR . 'assets/icons/' . $key . '.svg';
		}

		return $path;
	}

	/**
	 * (Maybe) Change header search markup based on the search mode.
	 *
	 * @param string $html
	 * @param string $element
	 * @return string
	 */
	public function modify_header_search( $html, $element ) {
		if ( in_array( $element, array( 'search-dropdown', 'search-bar' ) ) ) {
			$mode = eltron_get_theme_mod( 'header_search_mode' );

			if ( 'products' === $mode && function_exists( 'get_product_search_form' ) ) {
				$html = preg_replace( '/( eltron-header-search)/', '$1 woocommerce', $html );
				$html = preg_replace( '/<form(.*?)>(.|\s)*?<\/form>/', get_product_search_form( false ), $html ); // WPCS: XSS OK
			}
		}

		return $html;
	}

	/**
	 * ====================================================
	 * Customizer's partial refresh callback aliases
	 * ====================================================
	 */

	public function render_header_element__html_2() {
		eltron_header_element( 'html-2' );
	}

	public function render_header_element__html_3() {
		eltron_header_element( 'html-3' );
	}

	public function render_header_element__button_1() {
		eltron_header_element( 'button-1' );
	}

	public function render_header_element__button_2() {
		eltron_header_element( 'button-2' );
	}

	public function render_header_element__contact() {
		eltron_header_element( 'contact' );
	}
}

Eltron_Pro_Module_Header_Elements_Plus::instance();