<?php
/**
 * Customizer settings: Header > Alternate Header Colors
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_header_alt_colors';

/**
 * ====================================================
 * Desktop
 * ====================================================
 */

// Heading: Desktop Header
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_header_alt', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Desktop Header', 'eltron-features' ),
	'priority'    => 10,
) ) );

// Alternate Logo
$key = 'custom_logo_alt';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => 'absint',
) );
$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Alternate logo image', 'eltron-features' ),
	'mime_type'   => 'image',
	'priority'    => 10,
) ) );

$priority = 10;
$bars = array(
	'top_bar'    => esc_html__( 'Top Bar', 'eltron-features' ),
	'main_bar'   => esc_html__( 'Main Bar', 'eltron-features' ),
	'bottom_bar' => esc_html__( 'Bottom Bar', 'eltron-features' ),
);
foreach ( $bars as $bar => $label ) {
	$priority += 10;

	// ------
	$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_header_' . $bar . '_alt_colors', array(
		'section'     => $section,
		'settings'    => array(),
		'priority'    => $priority,
	) ) );

	// --- Blank: Colors
	$wp_customize->add_control( new Eltron_Customize_Control_Blank( $wp_customize, 'label_header_' . $bar . '_alt_colors', array(
		'section'     => $section,
		'settings'    => array(),
		'label'       => strtoupper( $label ),
		'priority'    => $priority,
	) ) );

	// Colors
	$colors = array(
		'header_' . $bar . '_alt_bg_color'                         => esc_html__( 'Background color', 'eltron-features' ),
		'header_' . $bar . '_alt_border_color'                     => esc_html__( 'Border color', 'eltron-features' ),
		'header_' . $bar . '_alt_text_color'                       => esc_html__( 'Text color', 'eltron-features' ),
		'header_' . $bar . '_alt_link_text_color'                  => esc_html__( 'Link text color', 'eltron-features' ),
		'header_' . $bar . '_alt_link_hover_text_color'            => esc_html__( 'Link text color :hover', 'eltron-features' ),
		'header_' . $bar . '_alt_link_active_text_color'           => esc_html__( 'Link text color :active', 'eltron-features' ),
		'header_' . $bar . '_alt_menu_hover_highlight_color'       => esc_html__( 'Highlight color :hover', 'eltron-features' ),
		'header_' . $bar . '_alt_menu_hover_highlight_text_color'  => esc_html__( 'Highlight text color :hover', 'eltron-features' ),
		'header_' . $bar . '_alt_menu_active_highlight_color'      => esc_html__( 'Highlight color :active', 'eltron-features' ),
		'header_' . $bar . '_alt_menu_active_highlight_text_color' => esc_html__( 'Highlight text color :active', 'eltron-features' ),
	);
	foreach ( $colors as $key => $label ) {
		$wp_customize->add_setting( $key, array(
			'default'     => eltron_array_value( $defaults, $key ),
			'transport'   => 'postMessage',
			'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
		) );
		$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
			'section'     => $section,
			'label'       => $label,
			'priority'    => $priority,
		) ) );
	}
}

/**
 * ====================================================
 * Colors
 * ====================================================
 */

// Heading: Mobile Header
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_header_mobile_alt', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Mobile Header', 'eltron-features' ),
	'priority'    => 50,
) ) );

// Alternate Mobile Logo
$key = 'custom_logo_mobile_alt';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => 'absint',
) );
$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Alternate mobile logo image', 'eltron-features' ),
	'mime_type'   => 'image',
	'priority'    => 50,
) ) );

// ------
$wp_customize->add_control( new Eltron_Customize_Control_HR( $wp_customize, 'hr_header_mobile_main_bar_alt_colors', array(
	'section'     => $section,
	'settings'    => array(),
	'priority'    => 60,
) ) );

// --- Blank: Colors
$wp_customize->add_control( new Eltron_Customize_Control_Blank( $wp_customize, 'label_header_mobile_main_bar_alt_colors', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => strtoupper( esc_html__( 'Mobile Main Bar', 'eltron-features' ) ),
	'priority'    => 60,
) ) );

// Colors
$colors = array(
	'header_mobile_main_bar_alt_bg_color'                 => esc_html__( 'Background color', 'eltron-features' ),
	'header_mobile_main_bar_alt_border_color'             => esc_html__( 'Border color', 'eltron-features' ),
	'header_mobile_main_bar_alt_link_text_color'          => esc_html__( 'Link text color', 'eltron-features' ),
	'header_mobile_main_bar_alt_link_hover_text_color'    => esc_html__( 'Link text color :hover', 'eltron-features' ),
);
foreach ( $colors as $key => $label ) {
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
	) );
	$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
		'section'     => $section,
		'label'       => $label,
		'priority'    => 60,
	) ) );
}