<?php
/**
 * Customizer sections
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$panel = 'eltron_panel_header';

// Alternate Header Colors
$wp_customize->add_section( 'eltron_section_header_alt_colors', array(
	'title'       => esc_html__( 'Alternate Header Colors', 'eltron-features' ),
	'description' => sprintf(
		/* translators: %s: link to "Page Settings" section. */
		esc_html__( 'Secondary color scheme that can be optionally applied to header bars. For example, your standard pages use light color scheme header, but you need to use dark color scheme header on some specific pages, you can set the dark color scheme via Alternate Header Colors. You can enable / disable this color scheme for each page type via %s.', 'eltron-features' ),
		'<a href="' . esc_url( add_query_arg( 'autofocus[panel]', 'eltron_panel_page_settings' ) ) . '" class="eltron-customize-goto-control">' . esc_html__( 'Page Settings', 'eltron-features' ) . '</a>'
	),
	'panel'       => $panel,
	'priority'    => 51,
) );