<?php
/**
 * Customizer settings: Footer > Builder
 *
 * @package Eltron Pro
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_footer_builder';

/**
 * ====================================================
 * Layout
 * ====================================================
 */

for ( $i = 1; $i <= 6; $i++ ) {
	// Column $i width.
	$key = 'footer_widgets_bar_column_' . $i . '_width';
	$settings = array(
		$key,
		$key . '__tablet',
		$key . '__mobile',
	);
	foreach ( $settings as $setting ) {
		$wp_customize->add_setting( $setting, array(
			'default'     => eltron_array_value( $defaults, $setting ),
			'transport'   => 'postMessage',
			'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
		) );
	}
	$wp_customize->add_control( new Eltron_Customize_Control_Dimension( $wp_customize, $key, array(
		'settings'    => $settings,
		'section'     => $section,
		/* translators: %d: column number. */
		'label'       => sprintf( esc_html__( '#%d width', 'eltron-features' ), $i ),
		'units'       => array(
			'%' => array(
				'min'  => 0,
				'max'  => 100,
				'step' => 0.01,
			),
		),
		'priority'    => 15,
	) ) );
}