<?php
/**
 * Eltron Pro module: Custom Fonts Elementor page
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

class Eltron_Pro_Module_Custom_Fonts_Elementor {

	/**
	 * Singleton instance
	 *
	 * @var Eltron_Pro_Module_Custom_Fonts_Elementor
	 */
	private static $instance;

	/**
	 * ====================================================
	 * Singleton & constructor functions
	 * ====================================================
	 */

	/**
	 * Get singleton instance.
	 *
	 * @return Eltron_Pro_Module_Custom_Fonts_Elementor
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Class constructor
	 */
	protected function __construct() {
		// Fonts groups
		add_filter( 'elementor/fonts/groups', array( $this, 'add_fonts_groups' ) );

		// Fonts choices
		add_filter( 'elementor/fonts/additional_fonts', array( $this, 'add_fonts_choices' ) );
	}

	/**
	 * ====================================================
	 * Hook functions
	 * ====================================================
	 */

	/**
	 * Add Eltron Custom Fonts group to Elementor fonts groups.
	 */
	public function add_fonts_groups( $groups ) {
		return array_merge(
			array(
				'eltron_custom_fonts' => sprintf( esc_html__( '%s - Custom', 'eltron-features' ), eltron_get_theme_info( 'name' ) ),
			),
			$groups
		);
	}

	/**
	 * Add Eltron Custom Fonts choices to Elementor fonts choices.
	 */
	public function add_fonts_choices( $choices ) {
		foreach( Eltron_Pro_Module_Custom_Fonts::instance()->get_custom_fonts() as $font => $stack ) {
			$choices[ $font ] = 'eltron_custom_fonts';
		}

		return $choices;
	}
}

Eltron_Pro_Module_Custom_Fonts_Elementor::instance();