<?php
/**
 * Eltron Pro module base class
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

abstract class Eltron_Pro_Module {

	/**
	 * Singleton instances
	 *
	 * @var array()
	 */
	protected static $instances = array();

	/**
	 * Module name
	 *
	 * @var string
	 */
	const MODULE_SLUG = '';

	/**
	 * ====================================================
	 * Singleton & constructor functions
	 * ====================================================
	 */

	/**
	 * Get singleton instance.
	 *
	 * @return Eltron_Pro_Module_WooCommerce_Quick_View
	 */
	public static function instance() {
		$called_class = get_called_class();
		if ( empty( static::$instances[ $called_class ] ) ) {
			static::$instances[ $called_class ] = new static();
		}
		return static::$instances[ $called_class ];
	}

	/**
	 * Class constructor
	 */
	protected function __construct() {
		// Frontend CSS & JS
		add_action( 'eltron/frontend/after_enqueue_main_css', array( $this, 'enqueue_css' ), 20 );
		add_action( 'eltron/frontend/after_enqueue_main_js', array( $this, 'enqueue_js' ), 20 );
	}
	
	/**
	 * ====================================================
	 * Hook functions
	 * ====================================================
	 */

	/**
	 * Enqueue frontend CSS.
	 */
	public function enqueue_css() {
		if ( ! wp_style_is( 'eltron-features', 'enqueued' ) ) {
			// Main CSS
			wp_enqueue_style( 'eltron-features', ELTRON_PRO_URI . 'assets/css/pro' . ELTRON_ASSETS_SUFFIX . '.css', array( 'eltron' ), ELTRON_PRO_VERSION );
			wp_style_add_data( 'eltron-features', 'rtl', 'replace' );

			// Inline CSS
			$dynamic_css = trim( apply_filters( 'eltron/frontend/pro_dynamic_css', '' ) );
			if ( ! empty( $dynamic_css ) ) {
				$dynamic_css = "/* Eltron Pro Dynamic CSS */\n" . $dynamic_css;
			}

			wp_add_inline_style( 'eltron-features', $dynamic_css );
		}
	}

	/**
	 * Enqueue frontend JS.
	 */
	public function enqueue_js() {
		if ( ! wp_script_is( 'eltron-features', 'enqueued' ) ) {
			// Main JS
			wp_enqueue_script( 'eltron-features', ELTRON_PRO_URI . 'assets/js/pro' . ELTRON_ASSETS_SUFFIX . '.js', array( 'eltron' ), ELTRON_PRO_VERSION, true );

			wp_localize_script( 'eltron-features', 'eltronProConfig', apply_filters( 'eltron/frontend/pro_localize_script', array(
				'ajaxURL' => admin_url( 'admin-ajax.php' ),
			) ) );
		}
	}
}