<?php
/**
 * Eltron Pro WooCommerce module base class
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

abstract class Eltron_Pro_Module_WooCommerce extends Eltron_Pro_Module {

	/**
	 * ====================================================
	 * Singleton & constructor functions
	 * ====================================================
	 */

	/**
	 * Class constructor
	 */
	protected function __construct() {
		parent::__construct();
	}

	/**
	 * ====================================================
	 * Hook functions
	 * ====================================================
	 */

	/**
	 * Enqueue frontend CSS.
	 */
	public function enqueue_css() {
		parent::enqueue_css();

		if ( ! wp_style_is( 'eltron-pro-woocommerce', 'enqueued' ) ) {
			// WooCommerce CSS
			wp_enqueue_style( 'eltron-pro-woocommerce', ELTRON_PRO_URI . 'assets/css/compatibilities/pro-woocommerce' . ELTRON_ASSETS_SUFFIX . '.css', array( 'eltron-features' ), ELTRON_PRO_VERSION );
			wp_style_add_data( 'eltron-pro-woocommerce', 'rtl', 'replace' );

			// Inline CSS
			$dynamic_css = trim( apply_filters( 'eltron/frontend/woocommerce/pro_dynamic_css', '' ) );
			if ( ! empty( $dynamic_css ) ) {
				$dynamic_css = "/* Eltron Pro + WooCommerce Dynamic CSS */\n" . $dynamic_css;
			}

			wp_add_inline_style( 'eltron-pro-woocommerce', $dynamic_css );
		}
	}

	/**
	 * Enqueue frontend JS.
	 */
	public function enqueue_js() {
		parent::enqueue_js();

		if ( ! wp_script_is( 'eltron-pro-woocommerce', 'enqueued' ) ) {
			// WooCommerce JS
			wp_enqueue_script( 'eltron-pro-woocommerce', ELTRON_PRO_URI . 'assets/js/compatibilities/pro-woocommerce' . ELTRON_ASSETS_SUFFIX . '.js', array( 'jquery', 'flexslider', 'wc-add-to-cart-variation' ), ELTRON_PRO_VERSION, true );
		}
	}
}