<?php
/**
 * Customizer & Front-End modification rules.
 *
 * @package Eltron
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$add = array();

/**
 * ====================================================
 * Blog > Post Layout: List
 * ====================================================
 */

$add['blog_index_list_items_gap'] = array(
	array(
		'type'     => 'css',
		'element'  => '.entry-layout-list',
		'property' => 'margin-bottom',
	),
);

$responsive = array(
	''         => '',
	'__tablet' => '@media screen and (max-width: 1023px)',
	'__mobile' => '@media screen and (max-width: 499px)',
);
foreach ( $responsive as $suffix => $media ) {
	$add['entry_list_padding' . $suffix ] = array(
		array(
			'type'     => 'css',
			'element'  => '.entry-layout-list .entry-wrapper',
			'property' => 'padding',
			'media'    => $media,
		),
	);
}
$add['entry_list_border'] = array(
	array(
		'type'     => 'css',
		'element'  => '.entry-layout-list .entry-wrapper',
		'property' => 'border-width',
	),
);

$add['entry_list_featured_media_position'] = array(
	array(
		'type'     => 'class',
		'element'  => '.eltron-loop-list',
		'pattern'  => 'eltron-loop-list-featured-media-position--$',
	),
);

$add['entry_list_featured_media_width'] = array(
	array(
		'type'     => 'css',
		'element'  => '.entry-layout-list .entry-list-media',
		'property' => 'flex-basis',
	),
);
$add['entry_list_featured_media_gap'] = array(
	array(
		'type'     => 'css',
		'element'  => '.entry-layout-list .entry-list-media',
		'property' => 'margin-bottom',
	),
	array(
		'type'     => 'css',
		'element'  => '.eltron-loop-list-featured-media-position--left .entry-layout-list .entry-list-media, .eltron-loop-list-featured-media-position--left-alt .entry-layout-list:nth-child(odd) .entry-list-media, .eltron-loop-list-featured-media-position--right-alt .entry-layout-list:nth-child(even) .entry-list-media',
		'property' => 'margin-right',
		'media'    => '@media screen and (min-width: 500px)',
	),
	array(
		'type'     => 'css',
		'element'  => '.eltron-loop-list-featured-media-position--right .entry-layout-list .entry-list-media, .eltron-loop-list-featured-media-position--right-alt .entry-layout-list:nth-child(odd) .entry-list-media, .eltron-loop-list-featured-media-position--left-alt .entry-layout-list:nth-child(even) .entry-list-media',
		'property' => 'margin-left',
		'media'    => '@media screen and (min-width: 500px)',
	),
);

$add['entry_list_bg_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.entry-layout-list .entry-wrapper',
		'property' => 'background-color',
	),
);

$add['entry_list_border_color'] = array(
	array(
		'type'     => 'css',
		'element'  => '.entry-layout-list .entry-wrapper',
		'property' => 'border-color',
	),
);

return $add;