<?php
/**
 * Customizer settings: Blog > Post Layout: List
 *
 * @package Eltron
 **/

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

$section = 'eltron_section_entry_list';

// Items gap
$key = 'blog_index_list_items_gap';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Slider( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Items gap', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'max'  => 120,
			'step' => 1,
		),
		'em' => array(
			'min'  => 0,
			'max'  => 8,
			'step' => 0.05,
		),
	),
	'priority'    => 10,
) ) );

/**
 * ====================================================
 * Item
 * ====================================================
 */

// Heading: Item
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_entry_list_item', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Item', 'eltron-features' ),
	'priority'    => 20,
) ) );

// Padding
$key = 'entry_list_padding';
$settings = array(
	$key,
	$key . '__tablet',
	$key . '__mobile',
);
foreach ( $settings as $setting ) {
	$wp_customize->add_setting( $setting, array(
		'default'     => eltron_array_value( $defaults, $setting ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimensions' ),
	) );
}
$wp_customize->add_control( new Eltron_Customize_Control_Dimensions( $wp_customize, $key, array(
	'settings'    => $settings,
	'section'     => $section,
	'label'       => esc_html__( 'Padding', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'step' => 1,
		),
		'em' => array(
			'min'  => 0,
			'step' => 0.05,
		),
	),
	'priority'    => 20,
) ) );

// Border
$key = 'entry_list_border';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimensions' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Dimensions( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Border', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'step' => 1,
		),
	),
	'priority'    => 20,
) ) );

/**
 * ====================================================
 * Featured Media
 * ====================================================
 */

// Heading: Featured Media
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_entry_list_featured_media', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Featured Media', 'eltron-features' ),
	'priority'    => 30,
) ) );

// Position
$key = 'entry_list_featured_media_position';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'transport'   => 'postMessage',
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_RadioImage( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Position', 'eltron-features' ),
	'choices'     => array(
		'disabled' => array(
			'label' => esc_html__( 'Disabled', 'eltron-features' ),
			'image' => ELTRON_PRO_URI . 'assets/images/customizer/entry-list-featured-media--disabled.svg',
		),
		'left' => array(
			'label' => is_rtl() ? esc_html__( 'Right', 'eltron-features' ) : esc_html__( 'Left', 'eltron-features' ),
			'image' => ELTRON_PRO_URI . 'assets/images/customizer/entry-list-featured-media--left.svg',
		),
		'right' => array(
			'label' => is_rtl() ? esc_html__( 'Left', 'eltron-features' ) : esc_html__( 'Right', 'eltron-features' ),
			'image' => ELTRON_PRO_URI . 'assets/images/customizer/entry-list-featured-media--right.svg',
		),
		'left-alt' => array(
			'label' => is_rtl() ? esc_html__( 'Right Alt', 'eltron-features' ) : esc_html__( 'Left Alt', 'eltron-features' ),
			'image' => ELTRON_PRO_URI . 'assets/images/customizer/entry-list-featured-media--left-alt.svg',
		),
		'right-alt' => array(
			'label' => is_rtl() ? esc_html__( 'Left Alt', 'eltron-features' ) : esc_html__( 'Right Alt', 'eltron-features' ),
			'image' => ELTRON_PRO_URI . 'assets/images/customizer/entry-list-featured-media--right-alt.svg',
		),
	),
	'priority'    => 30,
) ) );

// Width
$key = 'entry_list_featured_media_width';
$settings = array(
	$key,
	$key . '__tablet',
);
foreach ( $settings as $setting ) {
	$wp_customize->add_setting( $setting, array(
		'default'     => eltron_array_value( $defaults, $setting ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
	) );
}
$wp_customize->add_control( new Eltron_Customize_Control_Slider( $wp_customize, $key, array(
	'settings'    => $settings,
	'section'     => $section,
	'label'       => esc_html__( 'Width', 'eltron-features' ),
	'units'       => array(
		'%' => array(
			'min'  => 20,
			'max'  => 50,
			'step' => 0.5,
		),
	),
	'priority'    => 30,
) ) );

// Gap with text column
$key = 'entry_list_featured_media_gap';
$settings = array(
	$key,
	$key . '__tablet',
	$key . '__mobile',
);
foreach ( $settings as $setting ) {
	$wp_customize->add_setting( $setting, array(
		'default'     => eltron_array_value( $defaults, $setting ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
	) );
}
$wp_customize->add_control( new Eltron_Customize_Control_Slider( $wp_customize, $key, array(
	'settings'    => $settings,
	'section'     => $section,
	'label'       => esc_html__( 'Gap with text column', 'eltron-features' ),
	'units'       => array(
		'px' => array(
			'min'  => 0,
			'max'  => 150,
			'step' => 1,
		),
		'%' => array(
			'min'  => 0,
			'max'  => 20,
			'step' => 0.5,
		),
	),
	'priority'    => 30,
) ) );

/**
 * ====================================================
 * Post Header
 * ====================================================
 */

// Heading: Post Header
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_entry_list_header', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Post Header', 'eltron-features' ),
	'priority'    => 40,
) ) );

// Elements to display
$key = 'entry_list_header';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'multiselect' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Builder( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Elements to display', 'eltron-features' ),
	'choices'     => array(
		'header-meta' => esc_html__( 'Header Meta', 'eltron-features' ),
		'title'       => esc_html__( 'Title', 'eltron-features' ),
	),
	'layout'      => 'block',
	'priority'    => 40,
) ) );

// Header meta text
$key = 'entry_list_header_meta';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'text' ),
) );
$wp_customize->add_control( $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Header meta text', 'eltron-features' ),
	'description' => esc_html__( 'Available tags: {{date}}, {{categories}}, {{tags}}, {{author}}, {{avatar}}, {{comments}}.', 'eltron-features' ),
	'priority'    => 40,
) );

/**
 * ====================================================
 * Content
 * ====================================================
 */

// Heading: Content
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_entry_list_content', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Content', 'eltron-features' ),
	'priority'    => 50,
) ) );

// Entry list excerpt length
$key = 'entry_list_excerpt_length';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'dimension' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Slider( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Excerpt words limit', 'eltron-features' ),
	'description' => esc_html__( 'Fill with 0 to disable excerpt.', 'eltron-features' ),
	'units'       => array(
		'' => array(
			'min'  => 0,
			'max'  => 200,
			'step' => 1,
			'label' => 'wrd',
		),
	),
	'priority'    => 50,
) ) );

// Read more display
$key = 'entry_list_read_more_display';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'select' ),
) );
$wp_customize->add_control( $key, array(
	'type'        => 'select',
	'section'     => $section,
	'label'       => esc_html__( 'Read more display', 'eltron-features' ),
	'choices'     => array(
		''       => esc_html__( 'None', 'eltron-features' ),
		'text'   => esc_html__( 'Text', 'eltron-features' ),
		'button' => esc_html__( 'Button', 'eltron-features' ),
	),
	'priority'    => 50,
) );

// Read more text
$key = 'entry_list_read_more_text';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'text' ),
) );
$wp_customize->add_control( $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Read more text', 'eltron-features' ),
	'description' => esc_html__( 'Leave empty to disable read more link.', 'eltron-features' ),
	'priority'    => 50,
) );

/**
 * ====================================================
 * Post Footer
 * ====================================================
 */

// Heading: Post Footer
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_entry_list_footer', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Post Footer', 'eltron-features' ),
	'priority'    => 60,
) ) );

// Elements to display
$key = 'entry_list_footer';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'multiselect' ),
) );
$wp_customize->add_control( new Eltron_Customize_Control_Builder( $wp_customize, $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Elements to display', 'eltron-features' ),
	'choices'     => array(
		'footer-meta' => esc_html__( 'Footer Meta', 'eltron-features' ),
	),
	'layout'      => 'block',
	'priority'    => 60,
) ) );

// Footer meta text
$key = 'entry_list_footer_meta';
$wp_customize->add_setting( $key, array(
	'default'     => eltron_array_value( $defaults, $key ),
	'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'text' ),
) );
$wp_customize->add_control( $key, array(
	'section'     => $section,
	'label'       => esc_html__( 'Footer meta text', 'eltron-features' ),
	'description' => esc_html__( 'Available tags: {{date}}, {{categories}}, {{tags}}, {{author}}, {{avatar}}, {{comments}}.', 'eltron-features' ),
	'priority'    => 60,
) );

/**
 * ====================================================
 * Colors
 * ====================================================
 */

// Heading: Colors
$wp_customize->add_control( new Eltron_Customize_Control_Heading( $wp_customize, 'heading_entry_list_colors', array(
	'section'     => $section,
	'settings'    => array(),
	'label'       => esc_html__( 'Colors', 'eltron-features' ),
	'priority'    => 80,
) ) );

// Colors
$colors = array(
	'entry_list_bg_color'     => esc_html__( 'Background color', 'eltron-features' ),
	'entry_list_border_color' => esc_html__( 'Border color', 'eltron-features' ),
);
foreach ( $colors as $key => $label ) {
	$wp_customize->add_setting( $key, array(
		'default'     => eltron_array_value( $defaults, $key ),
		'transport'   => 'postMessage',
		'sanitize_callback' => array( 'Eltron_Customizer_Sanitization', 'color' ),
	) );
	$wp_customize->add_control( new Eltron_Customize_Control_Color( $wp_customize, $key, array(
		'section'     => $section,
		'label'       => $label,
		'priority'    => 80,
	) ) );
}