<?php
/**
 * Eltron Pro module: Blog Layout Plus
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) exit;

class Eltron_Pro_Module_Blog_Layout_Plus extends Eltron_Pro_Module_Blog {

	/**
	 * Module name
	 *
	 * @var string
	 */
	const MODULE_SLUG = 'blog-layout-plus';

	/**
	 * ====================================================
	 * Singleton & constructor functions
	 * ====================================================
	 */

	/**
	 * Class constructor
	 */
	protected function __construct() {
		parent::__construct();

		// Dynamic CSS
		add_filter( 'eltron/frontend/pro_dynamic_css', array( $this, 'add_dynamic_css' ) );
		
		// Customizer settings & values
		add_action( 'customize_register', array( $this, 'register_customizer_settings' ) );
		add_filter( 'eltron/customizer/setting_defaults', array( $this, 'add_customizer_setting_defaults' ) );
		add_filter( 'eltron/customizer/setting_postmessages', array( $this, 'add_customizer_setting_postmessages' ) );
		add_filter( 'eltron/customizer/control_contexts', array( $this, 'add_customizer_control_contexts' ) );

		// Template filters
		add_action( 'wp', array( $this, 'init_frontend' ) );
	}

	/**
	 * ====================================================
	 * Hook functions
	 * ====================================================
	 */

	/**
	 * Add dynamic CSS from customizer settings into the inline CSS.
	 *
	 * @param string $css
	 * @return string
	 */
	public function add_dynamic_css( $css ) {
		// Skip adding dynamic CSS on customizer preview frame.
		if ( is_customize_preview() ) {
			return $css;
		}

		$postmessages = include( ELTRON_PRO_DIR . '/inc/modules/' . self::MODULE_SLUG . '/customizer/postmessages.php' );

		$css .= Eltron_Customizer::instance()->convert_postmessages_to_css_string( $postmessages );

		return $css;
	}

	/**
	 * Register customizer sections, settings, and controls.
	 *
	 * @param WP_Customize_Manager $wp_customize
	 */
	public function register_customizer_settings( $wp_customize ) {
		$defaults = Eltron_Customizer::instance()->get_setting_defaults();

		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/_sections.php' );
		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/blog--archive.php' );
		require_once( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/options/blog--entry-list.php' );
	}

	/**
	 * Add default values for all Customizer settings.
	 *
	 * @param array $defaults
	 * @return array
	 */
	public function add_customizer_setting_defaults( $defaults = array() ) {
		$add = include( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/defaults.php' );

		return array_merge_recursive( $defaults, $add );
	}

	/**
	 * Add postmessage rules for some Customizer settings.
	 *
	 * @param array $postmessages
	 * @return array
	 */
	public function add_customizer_setting_postmessages( $postmessages = array() ) {
		$add = include( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/postmessages.php' );

		return array_merge_recursive( $postmessages, $add );
	}

	/**
	 * Add dependency contexts for some Customizer settings.
	 *
	 * @param array $contexts
	 * @return array
	 */
	public function add_customizer_control_contexts( $contexts = array() ) {
		$add = include( ELTRON_PRO_DIR . 'inc/modules/' . self::MODULE_SLUG . '/customizer/contexts.php' );

		return array_merge_recursive( $contexts, $add );
	}

	function init_frontend() {
		/**
		 * ====================================================
		 * Content list hooks
		 * ====================================================
		 */

		// Add featured media.
		if ( 'disabled' !== eltron_get_theme_mod( 'entry_list_featured_media_position' ) ) {
			add_filter( 'eltron/frontend/loop_classes', array( $this, 'add_loop_list_classes' ) );
			add_action( 'eltron/frontend/entry_list/media', array( $this, 'entry_list_featured_media' ), 10 );
		}

		// Add list entry header elements.
		$priority = 10;
		foreach ( eltron_get_theme_mod( 'entry_list_header', array() ) as $element ) {
			$function_name = 'entry_list_' . str_replace( '-', '_', $element );

			// If function exists, attach to hook.
			if ( method_exists( $this, $function_name ) ) {
				add_action( 'eltron/frontend/entry_list/header', array( $this, $function_name ), $priority );
			}

			// Increment priority number.
			$priority = $priority + 10;
		}

		// Add list entry footer elements.
		$priority = 10;
		foreach ( eltron_get_theme_mod( 'entry_list_footer', array() ) as $element ) {
			$function_name = 'entry_list_' . str_replace( '-', '_', $element );

			// If function exists, attach to hook.
			if ( method_exists( $this, $function_name ) ) {
				add_action( 'eltron/frontend/entry_list/footer', array( $this, $function_name ), $priority );
			}

			// Increment priority number.
			$priority = $priority + 10;
		}
	}

	/**
	 * Add custom classes to the array of posts loop classes.
	 *
	 * @param array $classes
	 * @return array
	 */
	public function add_loop_list_classes( $classes ) {
		if ( 'list' === eltron_get_theme_mod( 'blog_index_loop_mode' ) ) {
			$classes['entry_list_featured_media_position'] = esc_attr( 'eltron-loop-list-featured-media-position--' . eltron_get_theme_mod( 'entry_list_featured_media_position' ) );
		}

		return $classes;
	}

	/**
	 * ====================================================
	 * Render functions
	 * ====================================================
	 */

	/**
	 * Print entry list featured media.
	 */
	public function entry_list_featured_media() {
		if ( post_password_required() || is_attachment() || ! has_post_thumbnail() ) {
			return;
		}

		?>
		<a href="<?php echo esc_url( get_the_permalink() ); ?>" class="<?php echo esc_attr( implode( ' ', apply_filters( 'eltron/frontend/entry_list/thumbnail_classes', array( 'entry-thumbnail', 'entry-list-thumbnail' ) ) ) ); ?>">
			<?php the_post_thumbnail(
				get_the_ID(),
				apply_filters( 'eltron/frontend/entry_list/thumbnail_size', 'medium_large' )
			); ?>
		</a>
		<?php
	}

	/**
	 * Print entry list title.
	 */
	public function entry_list_title() {
		eltron_entry_title( 'small' );
	}

	/**
	 * Print entry list header meta.
	 */
	public function entry_list_header_meta() {
		eltron_entry_meta( eltron_get_theme_mod( 'entry_list_header_meta' ) );
	}

	/**
	 * Print entry list footer meta.
	 */
	public function entry_list_footer_meta() {
		eltron_entry_meta( eltron_get_theme_mod( 'entry_list_footer_meta' ) );
	}
}

Eltron_Pro_Module_Blog_Layout_Plus::instance();