(function() {
	'use strict';

	window.eltronPro = {

		/**
		 * Function to init sticky headers.
		 */
		initStickyHeaders: function() {
			var $desktopSection = document.querySelector( '.eltron-header-main .eltron-header-sticky' ),
			    $mobileSection = document.querySelector( '.eltron-header-mobile .eltron-header-sticky' ),
			    $canvas = document.getElementById( 'canvas' ),
			    $page = document.getElementById( 'page' ),
			    lastScroll = 0,
			    lastPageHeight = 0,
			    isScrolling = false;
				
			var updateSticky = function( e ) {
				// Detect and get the active header.
				var $section;

				if ( eltronConfig.breakpoints.desktop <= window.innerWidth ) {
					$section = $desktopSection;
				} else {
					$section = $mobileSection;
				}

				// Abort if there is no available sticky header section found.
				if ( ! $section ) {
					return;
				}

				// Abort if sticky header section is not visible.
				if ( ! eltronHelper.isVisible( $section ) ) {
					return;
				}

				if ( isScrolling ) {
					return;
				} else {
					isScrolling = true;
				}

				// Get window scroll position.
				var pageOffset = eltronHelper.getOffset( $page ).top,
				    windowScroll = window.pageYOffset;

				// Get some variables.
				var $bar = $section.querySelector( '.eltron-section-inner' ),
				    barNormalHeight = parseFloat( $section.getAttribute( 'data-height' ) ),
				    barStickyHeight = parseFloat( $section.getAttribute( 'data-sticky-height' ) ),
				    barWidth = $section.classList.contains( 'eltron-section-contained' ) ? Math.min( $section.offsetWidth, parseFloat( $section.getAttribute( 'data-container-width' ) ) ) : $section.offsetWidth,
				    barLeft = eltronHelper.getOffset( $section ).left + ( ( $section.offsetWidth - barWidth ) / 2 ),
				    
				    display = $section.getAttribute( 'data-sticky-display' ),
				    sectionScrollOffset = eltronHelper.getOffset( $section ).top - pageOffset,

				    $logo = $bar.querySelector( '.eltron-sticky-logo' ),
				    logoNormalWidth, logoStickyWidth, $logoImage;

				// Detect and get the logo.
				if ( $logo ) {
					logoNormalWidth = parseFloat( $logo.getAttribute( 'data-width' ) );
					logoStickyWidth = parseFloat( $logo.getAttribute( 'data-sticky-width' ) );
					$logoImage = $logo.querySelector( '.eltron-logo-image' );
				}

				// Detect sticky behavior.
				switch ( display ) {
					case 'on-scroll-up':
						// Page height change.
						if ( lastPageHeight !== $page.offsetHeight ) {
							// Reset to normal state.
							$section.classList.remove( 'eltron-sticky' );
							$section.classList.remove( 'eltron-sticky-in-view' );
							$bar.style.cssText = '';
						}
						// Scrolled down.
						else if ( windowScroll > lastScroll ) {
							if ( $section.classList.contains( 'eltron-sticky' ) ) {
								$section.classList.remove( 'eltron-sticky' );
								$bar.style.top = ( lastScroll + pageOffset - eltronHelper.getOffset( $section ).top ).toString() + 'px';
								$bar.style.left = 0;
								$bar.style.position = 'absolute';
								$bar.style.width = '100%';
								$bar.style.height = barStickyHeight.toString() + 'px';

								if ( $logoImage ) {
									$logoImage.style.width = logoStickyWidth.toString() + 'px';
								}
							}

							if ( $section.classList.contains( 'eltron-sticky-in-view' ) ) {
								if ( windowScroll > eltronHelper.getOffset( $bar ).top + barStickyHeight ) {
									$section.classList.remove( 'eltron-sticky-in-view' );
								}
							}
						}
						// Scrolled up.
						else if ( windowScroll < lastScroll ) {
							if ( $section.classList.contains( 'eltron-sticky' ) ) {
								if ( windowScroll <= sectionScrollOffset ) {
									$section.classList.remove( 'eltron-sticky' );
									$section.classList.remove( 'eltron-sticky-in-view' );
									$bar.style.top = null;
									$bar.style.left = null;
									$bar.style.position = null;
									$bar.style.height = null;
									$bar.style.width = null;

									if ( $logoImage ) {
										$logoImage.style.width = null;
									}
								}
								else if ( windowScroll < sectionScrollOffset + ( barNormalHeight - barStickyHeight ) ) {
									var barCurrentHeight = Math.max( barStickyHeight, barNormalHeight - ( windowScroll - sectionScrollOffset ) );

									$bar.style.height = barCurrentHeight.toString() + 'px';

									if ( $logoImage ) {
										var progress = barNormalHeight !== barStickyHeight ? ( barNormalHeight - barCurrentHeight ) / ( barNormalHeight - barStickyHeight ) : 1,
										    logoCurrentWidth = logoNormalWidth - ( progress * ( logoNormalWidth - logoStickyWidth ) );

										$logoImage.style.width = logoCurrentWidth.toString() + 'px';
									}
								}
							}
							else if ( $section.classList.contains( 'eltron-sticky-in-view' ) ) {
								if ( windowScroll < eltronHelper.getOffset( $bar ).top - pageOffset ) {
									$section.classList.add( 'eltron-sticky' );
									$bar.style.top = pageOffset.toString() + 'px';
									$bar.style.left = barLeft.toString() + 'px';
									$bar.style.position = null;
									$bar.style.width = barWidth.toString() + 'px';
									$bar.style.height = barStickyHeight.toString() + 'px';

									if ( $logoImage ) {
										$logoImage.style.width = logoStickyWidth.toString() + 'px';
									}
								}
							}
							else {
								if ( windowScroll > sectionScrollOffset + barNormalHeight ) {
									$section.classList.add( 'eltron-sticky-in-view' );
									$bar.style.top = ( windowScroll - barStickyHeight - sectionScrollOffset ).toString() + 'px';
									$bar.style.left = 0;
									$bar.style.position = 'absolute';
									$bar.style.width = '100%';
									$bar.style.height = barStickyHeight.toString() + 'px';

									if ( $logoImage ) {
										$logoImage.style.width = logoStickyWidth.toString() + 'px';
									}
								}									
							}
						}
						break;

					case 'fixed':
						// Inside sticky area.
						if ( windowScroll > sectionScrollOffset ) {
							var barCurrentHeight = Math.max( barStickyHeight, barNormalHeight - ( windowScroll - sectionScrollOffset ) );

							$section.classList.add( 'eltron-sticky' );
							$section.classList.add( 'eltron-sticky-in-view' );
							$bar.style.top = pageOffset.toString() + 'px';
							$bar.style.left = barLeft.toString() + 'px';
							$bar.style.width = barWidth.toString() + 'px';
							$bar.style.height = barCurrentHeight.toString() + 'px';

							if ( $logoImage ) {
								var progress = barNormalHeight !== barStickyHeight ? ( barNormalHeight - barCurrentHeight ) / ( barNormalHeight - barStickyHeight ) : 1,
								    logoCurrentWidth = logoNormalWidth - ( progress * ( logoNormalWidth - logoStickyWidth ) );

								$logoImage.style.width = logoCurrentWidth.toString() + 'px';
							}
						}
						// Outside sticky area.
						else {
							// Remove sticky mode if the section is sticky.
							if ( $section.classList.contains( 'eltron-sticky' ) ) {
								$section.classList.remove( 'eltron-sticky' );
								$section.classList.remove( 'eltron-sticky-in-view' );
								$bar.style.top = null;
								$bar.style.height = null;
								$bar.style.left = null;
								$bar.style.width = null;

								if ( $logoImage ) {
									$logoImage.style.width = null;
								}
							}
						}
						break;
				}

				// Update the "last run" information.
				lastScroll = windowScroll;
				lastPageHeight = $page.offsetHeight;
				isScrolling = false;
			};

			if ( $desktopSection || $mobileSection ) {
				window.addEventListener( 'resize', updateSticky, false );
				window.addEventListener( 'scroll', updateSticky, false );
				window.addEventListener( 'load', updateSticky, false );
				updateSticky();
			}
		},

		/**
		 * Function to init sticky sidebar.
		 */
		initStickySidebar: function() {
			var $sidebar = document.getElementById( 'secondary' );

			var updateSticky = function( e ) {

			};

			if ( $sidebar ) {
				window.addEventListener( 'resize', updateSticky, false );
				window.addEventListener( 'scroll', updateSticky, false );
				window.addEventListener( 'load', updateSticky, false );
				updateSticky();
			}
		},

		/**
		 * Function to init featured posts.
		 */
		initFeaturedPosts: function() {
			var $featuredPosts = document.getElementById( 'eltron-featured-posts' );

			if ( ! $featuredPosts ) {
				return;
			}

			// Slider and carousel (using tiny slider)
			if ( $featuredPosts.classList.contains( 'eltron-featured-posts-tiny-slider' ) ) {
				// Abort if tiny slider is not enqueued.
				if ( 'undefined' === typeof tns ) {
					return;
				}

				var args = JSON.parse( $featuredPosts.getAttribute( 'data-config' ) );

				args.container = $featuredPosts.querySelector( '.eltron-featured-posts-list' );
				args.controlsContainer = $featuredPosts.querySelector( '.eltron-featured-posts-navigation' );
				args.nav = false;
				args.speed = 250;
				args.autoplayButtonOutput = false;

				var $featuredPostsSlider = tns( args );
			}
		},

		/**
		 * Function that calls all init functions.
		 */
		initAll: function() {
			window.eltronPro.initStickyHeaders();
			window.eltronPro.initStickySidebar();
			window.eltronPro.initFeaturedPosts();
		},
	}

	document.addEventListener( 'DOMContentLoaded', window.eltronPro.initAll, false );

})();