<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.


/**
 * Register Post Type and Taxonomies
 *
 * @since 1.0
 */
function tt_service_module_cpt() {

	$with_front = $service_cpt_slug = $service_cpt_cat_slug = $service_cpt_single = $single_args = '';

	global $eltron_theme_components;

	//Include Elementor add_content
	if ( ( ! empty( $eltron_theme_components['service_cpt_single'] ) ) ) {
		$with_front = '0';
		$service_cpt_slug = 'service-item';
		$service_cpt_cat_slug = 'service-cats';
		$service_cpt_single = true;
	}

	// With Front
	if ( ! empty ( $with_front )  ) $with_front = true; else $with_front = false;

	// Single page
	if ( ! empty ( $service_cpt_single )  ) { // single item true
		$single_args =  array('show_ui' => true) ;
	} else {
		$single_args =  array(
						'exclude_from_search' => true,
						'show_in_admin_bar'   => false,
						'show_in_nav_menus'   => false,
						'publicly_queryable'  => false,
						'query_var'           => false,
		) ;
	}


	/**
	 * Register Post Type
	 */

	// Arguments
	$cpt_args = array(
		'labels' => array(
			'name' => esc_attr__( 'Service', 'eltron' ),
			'singular_name' => esc_attr__( 'Service', 'eltron' ),
			'add_new' => esc_attr__( 'Add Service', 'eltron' ),
			'add_new_item' => esc_attr__( 'Add Service', 'eltron' ),
			'edit' => esc_attr__( 'Edit', 'eltron' ),
			'edit_item' => esc_attr__( 'Edit Service', 'eltron' ),
			'new_item' => esc_attr__( 'New Service', 'eltron' ),
			'view' => esc_attr__( 'View Service', 'eltron' ),
			'view_item' => esc_attr__( 'View Service', 'eltron' ),
			'search_items' => esc_attr__( 'Search Service', 'eltron' ),
			'not_found' => esc_attr__( 'No Service found', 'eltron' ),
			'not_found_in_trash' => esc_attr__( 'No Service found in Trash', 'eltron' ),
			'parent' => esc_attr__( 'Parent Service', 'eltron' ),
		),
		'public' => true,
		'rewrite' => array( 'slug' => $service_cpt_slug, 'with_front' => $with_front ),
		'supports' => array( 'title', 'custom-fields', 'excerpt', 'editor', 'author', 'thumbnail', 'comments'  ),
	);

	// Single pages to be shown or not.
	$cpt_args = array_merge( $cpt_args, $single_args );

	// Apply filters
	$cpt_args = apply_filters( 'tt_service_cpt_args', $cpt_args );

	// Register Post Type
	register_post_type( 'tt_service', $cpt_args );

	/**
	 * Register Taxonomy ( Category )
	 */

	// Arguments
	$tax_args = array(
		'labels' => array(
			'name' => esc_attr__( 'Service Categories', 'eltron' ),
			'singular_name' => esc_attr__( 'Category', 'eltron' ),
			'search_items'  => esc_attr__( 'Search Categories', 'eltron' ),
			'all_items' => esc_attr__( 'All Categories', 'eltron' ),
			'parent_item' => esc_attr__( 'Parent Category', 'eltron' ),
			'parent_item_colon' => esc_attr__( 'Parent Category:', 'eltron' ),
			'edit_item' => esc_attr__( 'Edit Category', 'eltron' ),
			'update_item' => esc_attr__( 'Update Category', 'eltron' ),
			'add_new_item' => esc_attr__( 'Add New Category', 'eltron' ),
			'new_item_name' => esc_attr__( 'New Category Name', 'eltron' ),
			'menu_name' => esc_attr__( 'Categories', 'eltron' ),
		),
		'hierarchical' => true,
		'public' => true,
		'rewrite' => array(
			'slug' => $service_cpt_cat_slug,
			'with_front' => $with_front
		),
	);

	// Apply filters
	$tax_args = apply_filters( 'tt_service_cats_args', $tax_args );

	// Register Taxonomy
	register_taxonomy( 'tt_service_cats', 'tt_service', $tax_args );

} add_action( 'init', 'tt_service_module_cpt' );